export var validateWaiterOptions = function (options) {
    if (options.maxWaitTime < 1) {
        throw new Error("WaiterConfiguration.maxWaitTime must be greater than 0");
    }
    else if (options.minDelay < 1) {
        throw new Error("WaiterConfiguration.minDelay must be greater than 0");
    }
    else if (options.maxDelay < 1) {
        throw new Error("WaiterConfiguration.maxDelay must be greater than 0");
    }
    else if (options.maxWaitTime <= options.minDelay) {
        throw new Error("WaiterConfiguration.maxWaitTime [".concat(options.maxWaitTime, "] must be greater than WaiterConfiguration.minDelay [").concat(options.minDelay, "] for this waiter"));
    }
    else if (options.maxDelay < options.minDelay) {
        throw new Error("WaiterConfiguration.maxDelay [".concat(options.maxDelay, "] must be greater than WaiterConfiguration.minDelay [").concat(options.minDelay, "] for this waiter"));
    }
};
