import { __awaiter, __generator } from "tslib";
import { Readable } from "stream";
export var getAwsChunkedEncodingStream = function (readableStream, options) {
    var base64Encoder = options.base64Encoder, bodyLengthChecker = options.bodyLengthChecker, checksumAlgorithmFn = options.checksumAlgorithmFn, checksumLocationName = options.checksumLocationName, streamHasher = options.streamHasher;
    var checksumRequired = base64Encoder !== undefined &&
        checksumAlgorithmFn !== undefined &&
        checksumLocationName !== undefined &&
        streamHasher !== undefined;
    var digest = checksumRequired ? streamHasher(checksumAlgorithmFn, readableStream) : undefined;
    var awsChunkedEncodingStream = new Readable({ read: function () { } });
    readableStream.on("data", function (data) {
        awsChunkedEncodingStream.push("".concat((bodyLengthChecker(data) || 0).toString(16), "\r\n").concat(data.toString(), "\r\n"));
    });
    readableStream.on("end", function () { return __awaiter(void 0, void 0, void 0, function () {
        var checksum, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    awsChunkedEncodingStream.push("0\r\n");
                    if (!checksumRequired) return [3, 2];
                    _a = base64Encoder;
                    return [4, digest];
                case 1:
                    checksum = _a.apply(void 0, [_b.sent()]);
                    awsChunkedEncodingStream.push("".concat(checksumLocationName, ":").concat(checksum, "\r\n"));
                    awsChunkedEncodingStream.push("\r\n");
                    _b.label = 2;
                case 2:
                    awsChunkedEncodingStream.push(null);
                    return [2];
            }
        });
    }); });
    return awsChunkedEncodingStream;
};
