import { HttpResponse, MetadataBearer, ResponseMetadata, RetryableTrait, SmithyException } from "@aws-sdk/types";

export declare type ExceptionOptionType<ExceptionType extends Error, BaseExceptionType extends Error> = Pick<ExceptionType, Exclude<keyof ExceptionType, Exclude<keyof BaseExceptionType, "$metadata">>>;
export interface ServiceExceptionOptions extends SmithyException, MetadataBearer {
    message?: string;
}

export declare class ServiceException extends Error implements SmithyException, MetadataBearer {
    readonly $fault: "client" | "server";
    $response?: HttpResponse;
    $retryable?: RetryableTrait;
    $metadata: ResponseMetadata;
    constructor(options: ServiceExceptionOptions);
}

export declare const decorateServiceException: <E extends ServiceException>(exception: E, additions?: {
    [key: string]: any;
}) => E;
