"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUseRegionalEndpointPlugin = exports.useRegionalEndpointMiddlewareOptions = exports.useRegionalEndpointMiddleware = void 0;
const protocol_http_1 = require("@aws-sdk/protocol-http");
const useRegionalEndpointMiddleware = (config) => (next) => async (args) => {
    const { request } = args;
    if (!protocol_http_1.HttpRequest.isInstance(request) || config.isCustomEndpoint)
        return next({ ...args });
    if (request.hostname === "s3.amazonaws.com") {
        request.hostname = "s3.us-east-1.amazonaws.com";
    }
    else if ("aws-global" === (await config.region())) {
        request.hostname = "s3.amazonaws.com";
    }
    return next({ ...args });
};
exports.useRegionalEndpointMiddleware = useRegionalEndpointMiddleware;
exports.useRegionalEndpointMiddlewareOptions = {
    step: "build",
    tags: ["USE_REGIONAL_ENDPOINT", "S3"],
    name: "useRegionalEndpointMiddleware",
    override: true,
};
const getUseRegionalEndpointPlugin = (config) => ({
    applyToStack: (clientStack) => {
        clientStack.add((0, exports.useRegionalEndpointMiddleware)(config), exports.useRegionalEndpointMiddlewareOptions);
    },
});
exports.getUseRegionalEndpointPlugin = getUseRegionalEndpointPlugin;
