"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.headerDefault = void 0;
const protocol_http_1 = require("@aws-sdk/protocol-http");
function headerDefault(headerBag) {
    return (next) => {
        return (args) => {
            if (protocol_http_1.HttpRequest.isInstance(args.request)) {
                const headers = { ...args.request.headers };
                for (const name of Object.keys(headerBag)) {
                    if (!(name in headers)) {
                        headers[name] = headerBag[name];
                    }
                }
                return next({
                    ...args,
                    request: {
                        ...args.request,
                        headers,
                    },
                });
            }
            else {
                return next(args);
            }
        };
    };
}
exports.headerDefault = headerDefault;
