import { HashCalculator } from "./HashCalculator";
export var readableStreamHasher = function (hashCtor, readableStream) {
    if (readableStream.readableFlowing !== null) {
        throw new Error("Unable to calculate hash for flowing readable stream");
    }
    var hash = new hashCtor();
    var hashCalculator = new HashCalculator(hash);
    readableStream.pipe(hashCalculator);
    return new Promise(function (resolve, reject) {
        readableStream.on("error", function (err) {
            hashCalculator.end();
            reject(err);
        });
        hashCalculator.on("error", reject);
        hashCalculator.on("finish", function () {
            hash.digest().then(resolve).catch(reject);
        });
    });
};
