
import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { Readable } from "stream";
import { ChecksumAlgorithm, Grant, ObjectCannedACL, ObjectLockLegalHoldStatus, ObjectLockMode, ObjectLockRetention, PublicAccessBlockConfiguration, ReplicationStatus, RequestCharged, RequestPayer, ServerSideEncryption, StorageClass, Tagging } from "./models_0";
import { S3ServiceException as __BaseException } from "./S3ServiceException";
export interface PutObjectRetentionOutput {
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace PutObjectRetentionOutput {
    
    const filterSensitiveLog: (obj: PutObjectRetentionOutput) => any;
}
export interface PutObjectRetentionRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    Retention?: ObjectLockRetention;
    
    RequestPayer?: RequestPayer | string;
    
    VersionId?: string;
    
    BypassGovernanceRetention?: boolean;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutObjectRetentionRequest {
    
    const filterSensitiveLog: (obj: PutObjectRetentionRequest) => any;
}
export interface PutObjectTaggingOutput {
    
    VersionId?: string;
}
export declare namespace PutObjectTaggingOutput {
    
    const filterSensitiveLog: (obj: PutObjectTaggingOutput) => any;
}
export interface PutObjectTaggingRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    Tagging: Tagging | undefined;
    
    ExpectedBucketOwner?: string;
    
    RequestPayer?: RequestPayer | string;
}
export declare namespace PutObjectTaggingRequest {
    
    const filterSensitiveLog: (obj: PutObjectTaggingRequest) => any;
}
export interface PutPublicAccessBlockRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    PublicAccessBlockConfiguration: PublicAccessBlockConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutPublicAccessBlockRequest {
    
    const filterSensitiveLog: (obj: PutPublicAccessBlockRequest) => any;
}

export declare class ObjectAlreadyInActiveTierError extends __BaseException {
    readonly name: "ObjectAlreadyInActiveTierError";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ObjectAlreadyInActiveTierError, __BaseException>);
}
export interface RestoreObjectOutput {
    
    RequestCharged?: RequestCharged | string;
    
    RestoreOutputPath?: string;
}
export declare namespace RestoreObjectOutput {
    
    const filterSensitiveLog: (obj: RestoreObjectOutput) => any;
}
export declare type Tier = "Bulk" | "Expedited" | "Standard";

export interface GlacierJobParameters {
    
    Tier: Tier | string | undefined;
}
export declare namespace GlacierJobParameters {
    
    const filterSensitiveLog: (obj: GlacierJobParameters) => any;
}

export interface Encryption {
    
    EncryptionType: ServerSideEncryption | string | undefined;
    
    KMSKeyId?: string;
    
    KMSContext?: string;
}
export declare namespace Encryption {
    
    const filterSensitiveLog: (obj: Encryption) => any;
}

export interface MetadataEntry {
    
    Name?: string;
    
    Value?: string;
}
export declare namespace MetadataEntry {
    
    const filterSensitiveLog: (obj: MetadataEntry) => any;
}

export interface S3Location {
    
    BucketName: string | undefined;
    
    Prefix: string | undefined;
    
    Encryption?: Encryption;
    
    CannedACL?: ObjectCannedACL | string;
    
    AccessControlList?: Grant[];
    
    Tagging?: Tagging;
    
    UserMetadata?: MetadataEntry[];
    
    StorageClass?: StorageClass | string;
}
export declare namespace S3Location {
    
    const filterSensitiveLog: (obj: S3Location) => any;
}

export interface OutputLocation {
    
    S3?: S3Location;
}
export declare namespace OutputLocation {
    
    const filterSensitiveLog: (obj: OutputLocation) => any;
}
export declare type ExpressionType = "SQL";
export declare type CompressionType = "BZIP2" | "GZIP" | "NONE";
export declare enum FileHeaderInfo {
    IGNORE = "IGNORE",
    NONE = "NONE",
    USE = "USE"
}

export interface CSVInput {
    
    FileHeaderInfo?: FileHeaderInfo | string;
    
    Comments?: string;
    
    QuoteEscapeCharacter?: string;
    
    RecordDelimiter?: string;
    
    FieldDelimiter?: string;
    
    QuoteCharacter?: string;
    
    AllowQuotedRecordDelimiter?: boolean;
}
export declare namespace CSVInput {
    
    const filterSensitiveLog: (obj: CSVInput) => any;
}
export declare enum JSONType {
    DOCUMENT = "DOCUMENT",
    LINES = "LINES"
}

export interface JSONInput {
    
    Type?: JSONType | string;
}
export declare namespace JSONInput {
    
    const filterSensitiveLog: (obj: JSONInput) => any;
}

export interface ParquetInput {
}
export declare namespace ParquetInput {
    
    const filterSensitiveLog: (obj: ParquetInput) => any;
}

export interface InputSerialization {
    
    CSV?: CSVInput;
    
    CompressionType?: CompressionType | string;
    
    JSON?: JSONInput;
    
    Parquet?: ParquetInput;
}
export declare namespace InputSerialization {
    
    const filterSensitiveLog: (obj: InputSerialization) => any;
}
export declare enum QuoteFields {
    ALWAYS = "ALWAYS",
    ASNEEDED = "ASNEEDED"
}

export interface CSVOutput {
    
    QuoteFields?: QuoteFields | string;
    
    QuoteEscapeCharacter?: string;
    
    RecordDelimiter?: string;
    
    FieldDelimiter?: string;
    
    QuoteCharacter?: string;
}
export declare namespace CSVOutput {
    
    const filterSensitiveLog: (obj: CSVOutput) => any;
}

export interface JSONOutput {
    
    RecordDelimiter?: string;
}
export declare namespace JSONOutput {
    
    const filterSensitiveLog: (obj: JSONOutput) => any;
}

export interface OutputSerialization {
    
    CSV?: CSVOutput;
    
    JSON?: JSONOutput;
}
export declare namespace OutputSerialization {
    
    const filterSensitiveLog: (obj: OutputSerialization) => any;
}

export interface SelectParameters {
    
    InputSerialization: InputSerialization | undefined;
    
    ExpressionType: ExpressionType | string | undefined;
    
    Expression: string | undefined;
    
    OutputSerialization: OutputSerialization | undefined;
}
export declare namespace SelectParameters {
    
    const filterSensitiveLog: (obj: SelectParameters) => any;
}
export declare enum RestoreRequestType {
    SELECT = "SELECT"
}

export interface RestoreRequest {
    
    Days?: number;
    
    GlacierJobParameters?: GlacierJobParameters;
    
    Type?: RestoreRequestType | string;
    
    Tier?: Tier | string;
    
    Description?: string;
    
    SelectParameters?: SelectParameters;
    
    OutputLocation?: OutputLocation;
}
export declare namespace RestoreRequest {
    
    const filterSensitiveLog: (obj: RestoreRequest) => any;
}
export interface RestoreObjectRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    RestoreRequest?: RestoreRequest;
    
    RequestPayer?: RequestPayer | string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace RestoreObjectRequest {
    
    const filterSensitiveLog: (obj: RestoreObjectRequest) => any;
}

export interface ContinuationEvent {
}
export declare namespace ContinuationEvent {
    
    const filterSensitiveLog: (obj: ContinuationEvent) => any;
}

export interface EndEvent {
}
export declare namespace EndEvent {
    
    const filterSensitiveLog: (obj: EndEvent) => any;
}

export interface Progress {
    
    BytesScanned?: number;
    
    BytesProcessed?: number;
    
    BytesReturned?: number;
}
export declare namespace Progress {
    
    const filterSensitiveLog: (obj: Progress) => any;
}

export interface ProgressEvent {
    
    Details?: Progress;
}
export declare namespace ProgressEvent {
    
    const filterSensitiveLog: (obj: ProgressEvent) => any;
}

export interface RecordsEvent {
    
    Payload?: Uint8Array;
}
export declare namespace RecordsEvent {
    
    const filterSensitiveLog: (obj: RecordsEvent) => any;
}

export interface Stats {
    
    BytesScanned?: number;
    
    BytesProcessed?: number;
    
    BytesReturned?: number;
}
export declare namespace Stats {
    
    const filterSensitiveLog: (obj: Stats) => any;
}

export interface StatsEvent {
    
    Details?: Stats;
}
export declare namespace StatsEvent {
    
    const filterSensitiveLog: (obj: StatsEvent) => any;
}

export declare type SelectObjectContentEventStream = SelectObjectContentEventStream.ContMember | SelectObjectContentEventStream.EndMember | SelectObjectContentEventStream.ProgressMember | SelectObjectContentEventStream.RecordsMember | SelectObjectContentEventStream.StatsMember | SelectObjectContentEventStream.$UnknownMember;
export declare namespace SelectObjectContentEventStream {
    
    interface RecordsMember {
        Records: RecordsEvent;
        Stats?: never;
        Progress?: never;
        Cont?: never;
        End?: never;
        $unknown?: never;
    }
    
    interface StatsMember {
        Records?: never;
        Stats: StatsEvent;
        Progress?: never;
        Cont?: never;
        End?: never;
        $unknown?: never;
    }
    
    interface ProgressMember {
        Records?: never;
        Stats?: never;
        Progress: ProgressEvent;
        Cont?: never;
        End?: never;
        $unknown?: never;
    }
    
    interface ContMember {
        Records?: never;
        Stats?: never;
        Progress?: never;
        Cont: ContinuationEvent;
        End?: never;
        $unknown?: never;
    }
    
    interface EndMember {
        Records?: never;
        Stats?: never;
        Progress?: never;
        Cont?: never;
        End: EndEvent;
        $unknown?: never;
    }
    interface $UnknownMember {
        Records?: never;
        Stats?: never;
        Progress?: never;
        Cont?: never;
        End?: never;
        $unknown: [
            string,
            any
        ];
    }
    interface Visitor<T> {
        Records: (value: RecordsEvent) => T;
        Stats: (value: StatsEvent) => T;
        Progress: (value: ProgressEvent) => T;
        Cont: (value: ContinuationEvent) => T;
        End: (value: EndEvent) => T;
        _: (name: string, value: any) => T;
    }
    const visit: <T>(value: SelectObjectContentEventStream, visitor: Visitor<T>) => T;
    
    const filterSensitiveLog: (obj: SelectObjectContentEventStream) => any;
}
export interface SelectObjectContentOutput {
    
    Payload?: AsyncIterable<SelectObjectContentEventStream>;
}
export declare namespace SelectObjectContentOutput {
    
    const filterSensitiveLog: (obj: SelectObjectContentOutput) => any;
}

export interface RequestProgress {
    
    Enabled?: boolean;
}
export declare namespace RequestProgress {
    
    const filterSensitiveLog: (obj: RequestProgress) => any;
}

export interface ScanRange {
    
    Start?: number;
    
    End?: number;
}
export declare namespace ScanRange {
    
    const filterSensitiveLog: (obj: ScanRange) => any;
}

export interface SelectObjectContentRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    Expression: string | undefined;
    
    ExpressionType: ExpressionType | string | undefined;
    
    RequestProgress?: RequestProgress;
    
    InputSerialization: InputSerialization | undefined;
    
    OutputSerialization: OutputSerialization | undefined;
    
    ScanRange?: ScanRange;
    
    ExpectedBucketOwner?: string;
}
export declare namespace SelectObjectContentRequest {
    
    const filterSensitiveLog: (obj: SelectObjectContentRequest) => any;
}
export interface UploadPartOutput {
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    ETag?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace UploadPartOutput {
    
    const filterSensitiveLog: (obj: UploadPartOutput) => any;
}
export interface UploadPartRequest {
    
    Body?: Readable | ReadableStream | Blob;
    
    Bucket: string | undefined;
    
    ContentLength?: number;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    Key: string | undefined;
    
    PartNumber: number | undefined;
    
    UploadId: string | undefined;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace UploadPartRequest {
    
    const filterSensitiveLog: (obj: UploadPartRequest) => any;
}

export interface CopyPartResult {
    
    ETag?: string;
    
    LastModified?: Date;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
}
export declare namespace CopyPartResult {
    
    const filterSensitiveLog: (obj: CopyPartResult) => any;
}
export interface UploadPartCopyOutput {
    
    CopySourceVersionId?: string;
    
    CopyPartResult?: CopyPartResult;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace UploadPartCopyOutput {
    
    const filterSensitiveLog: (obj: UploadPartCopyOutput) => any;
}
export interface UploadPartCopyRequest {
    
    Bucket: string | undefined;
    
    CopySource: string | undefined;
    
    CopySourceIfMatch?: string;
    
    CopySourceIfModifiedSince?: Date;
    
    CopySourceIfNoneMatch?: string;
    
    CopySourceIfUnmodifiedSince?: Date;
    
    CopySourceRange?: string;
    
    Key: string | undefined;
    
    PartNumber: number | undefined;
    
    UploadId: string | undefined;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    CopySourceSSECustomerAlgorithm?: string;
    
    CopySourceSSECustomerKey?: string;
    
    CopySourceSSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
    
    ExpectedSourceBucketOwner?: string;
}
export declare namespace UploadPartCopyRequest {
    
    const filterSensitiveLog: (obj: UploadPartCopyRequest) => any;
}
export interface WriteGetObjectResponseRequest {
    
    RequestRoute: string | undefined;
    
    RequestToken: string | undefined;
    
    Body?: Readable | ReadableStream | Blob;
    
    StatusCode?: number;
    
    ErrorCode?: string;
    
    ErrorMessage?: string;
    
    AcceptRanges?: string;
    
    CacheControl?: string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentLength?: number;
    
    ContentRange?: string;
    
    ContentType?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    DeleteMarker?: boolean;
    
    ETag?: string;
    
    Expires?: Date;
    
    Expiration?: string;
    
    LastModified?: Date;
    
    MissingMeta?: number;
    
    Metadata?: {
        [key: string]: string;
    };
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    PartsCount?: number;
    
    ReplicationStatus?: ReplicationStatus | string;
    
    RequestCharged?: RequestCharged | string;
    
    Restore?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    SSECustomerAlgorithm?: string;
    
    SSEKMSKeyId?: string;
    
    SSECustomerKeyMD5?: string;
    
    StorageClass?: StorageClass | string;
    
    TagCount?: number;
    
    VersionId?: string;
    
    BucketKeyEnabled?: boolean;
}
export declare namespace WriteGetObjectResponseRequest {
    
    const filterSensitiveLog: (obj: WriteGetObjectResponseRequest) => any;
}
