
import { ExceptionOptionType as __ExceptionOptionType } from "@aws-sdk/smithy-client";
import { Readable } from "stream";
import { S3ServiceException as __BaseException } from "./S3ServiceException";

export interface AbortIncompleteMultipartUpload {
    
    DaysAfterInitiation?: number;
}
export declare namespace AbortIncompleteMultipartUpload {
    
    const filterSensitiveLog: (obj: AbortIncompleteMultipartUpload) => any;
}
export declare type RequestCharged = "requester";
export interface AbortMultipartUploadOutput {
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace AbortMultipartUploadOutput {
    
    const filterSensitiveLog: (obj: AbortMultipartUploadOutput) => any;
}
export declare type RequestPayer = "requester";
export interface AbortMultipartUploadRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    UploadId: string | undefined;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace AbortMultipartUploadRequest {
    
    const filterSensitiveLog: (obj: AbortMultipartUploadRequest) => any;
}

export declare class NoSuchUpload extends __BaseException {
    readonly name: "NoSuchUpload";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<NoSuchUpload, __BaseException>);
}
export declare type BucketAccelerateStatus = "Enabled" | "Suspended";

export interface AccelerateConfiguration {
    
    Status?: BucketAccelerateStatus | string;
}
export declare namespace AccelerateConfiguration {
    
    const filterSensitiveLog: (obj: AccelerateConfiguration) => any;
}
export declare type Type = "AmazonCustomerByEmail" | "CanonicalUser" | "Group";

export interface Grantee {
    
    DisplayName?: string;
    
    EmailAddress?: string;
    
    ID?: string;
    
    URI?: string;
    
    Type: Type | string | undefined;
}
export declare namespace Grantee {
    
    const filterSensitiveLog: (obj: Grantee) => any;
}
export declare type Permission = "FULL_CONTROL" | "READ" | "READ_ACP" | "WRITE" | "WRITE_ACP";

export interface Grant {
    
    Grantee?: Grantee;
    
    Permission?: Permission | string;
}
export declare namespace Grant {
    
    const filterSensitiveLog: (obj: Grant) => any;
}

export interface Owner {
    
    DisplayName?: string;
    
    ID?: string;
}
export declare namespace Owner {
    
    const filterSensitiveLog: (obj: Owner) => any;
}

export interface AccessControlPolicy {
    
    Grants?: Grant[];
    
    Owner?: Owner;
}
export declare namespace AccessControlPolicy {
    
    const filterSensitiveLog: (obj: AccessControlPolicy) => any;
}
export declare type OwnerOverride = "Destination";

export interface AccessControlTranslation {
    
    Owner: OwnerOverride | string | undefined;
}
export declare namespace AccessControlTranslation {
    
    const filterSensitiveLog: (obj: AccessControlTranslation) => any;
}
export declare type ServerSideEncryption = "AES256" | "aws:kms";
export interface CompleteMultipartUploadOutput {
    
    Location?: string;
    
    Bucket?: string;
    
    Key?: string;
    
    Expiration?: string;
    
    ETag?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    VersionId?: string;
    
    SSEKMSKeyId?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace CompleteMultipartUploadOutput {
    
    const filterSensitiveLog: (obj: CompleteMultipartUploadOutput) => any;
}

export interface CompletedPart {
    
    ETag?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    PartNumber?: number;
}
export declare namespace CompletedPart {
    
    const filterSensitiveLog: (obj: CompletedPart) => any;
}

export interface CompletedMultipartUpload {
    
    Parts?: CompletedPart[];
}
export declare namespace CompletedMultipartUpload {
    
    const filterSensitiveLog: (obj: CompletedMultipartUpload) => any;
}
export interface CompleteMultipartUploadRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    MultipartUpload?: CompletedMultipartUpload;
    
    UploadId: string | undefined;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
}
export declare namespace CompleteMultipartUploadRequest {
    
    const filterSensitiveLog: (obj: CompleteMultipartUploadRequest) => any;
}

export interface CopyObjectResult {
    
    ETag?: string;
    
    LastModified?: Date;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
}
export declare namespace CopyObjectResult {
    
    const filterSensitiveLog: (obj: CopyObjectResult) => any;
}
export interface CopyObjectOutput {
    
    CopyObjectResult?: CopyObjectResult;
    
    Expiration?: string;
    
    CopySourceVersionId?: string;
    
    VersionId?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace CopyObjectOutput {
    
    const filterSensitiveLog: (obj: CopyObjectOutput) => any;
}
export declare type ObjectCannedACL = "authenticated-read" | "aws-exec-read" | "bucket-owner-full-control" | "bucket-owner-read" | "private" | "public-read" | "public-read-write";
export declare enum ChecksumAlgorithm {
    CRC32 = "CRC32",
    CRC32C = "CRC32C",
    SHA1 = "SHA1",
    SHA256 = "SHA256"
}
export declare type MetadataDirective = "COPY" | "REPLACE";
export declare type ObjectLockLegalHoldStatus = "OFF" | "ON";
export declare type ObjectLockMode = "COMPLIANCE" | "GOVERNANCE";
export declare type StorageClass = "DEEP_ARCHIVE" | "GLACIER" | "GLACIER_IR" | "INTELLIGENT_TIERING" | "ONEZONE_IA" | "OUTPOSTS" | "REDUCED_REDUNDANCY" | "STANDARD" | "STANDARD_IA";
export declare type TaggingDirective = "COPY" | "REPLACE";
export interface CopyObjectRequest {
    
    ACL?: ObjectCannedACL | string;
    
    Bucket: string | undefined;
    
    CacheControl?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentType?: string;
    
    CopySource: string | undefined;
    
    CopySourceIfMatch?: string;
    
    CopySourceIfModifiedSince?: Date;
    
    CopySourceIfNoneMatch?: string;
    
    CopySourceIfUnmodifiedSince?: Date;
    
    Expires?: Date;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWriteACP?: string;
    
    Key: string | undefined;
    
    Metadata?: {
        [key: string]: string;
    };
    
    MetadataDirective?: MetadataDirective | string;
    
    TaggingDirective?: TaggingDirective | string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    StorageClass?: StorageClass | string;
    
    WebsiteRedirectLocation?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    CopySourceSSECustomerAlgorithm?: string;
    
    CopySourceSSECustomerKey?: string;
    
    CopySourceSSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    Tagging?: string;
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
    
    ExpectedBucketOwner?: string;
    
    ExpectedSourceBucketOwner?: string;
}
export declare namespace CopyObjectRequest {
    
    const filterSensitiveLog: (obj: CopyObjectRequest) => any;
}

export declare class ObjectNotInActiveTierError extends __BaseException {
    readonly name: "ObjectNotInActiveTierError";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<ObjectNotInActiveTierError, __BaseException>);
}

export declare class BucketAlreadyExists extends __BaseException {
    readonly name: "BucketAlreadyExists";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<BucketAlreadyExists, __BaseException>);
}

export declare class BucketAlreadyOwnedByYou extends __BaseException {
    readonly name: "BucketAlreadyOwnedByYou";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<BucketAlreadyOwnedByYou, __BaseException>);
}
export interface CreateBucketOutput {
    
    Location?: string;
}
export declare namespace CreateBucketOutput {
    
    const filterSensitiveLog: (obj: CreateBucketOutput) => any;
}
export declare type BucketCannedACL = "authenticated-read" | "private" | "public-read" | "public-read-write";
export declare type BucketLocationConstraint = "EU" | "af-south-1" | "ap-east-1" | "ap-northeast-1" | "ap-northeast-2" | "ap-northeast-3" | "ap-south-1" | "ap-southeast-1" | "ap-southeast-2" | "ca-central-1" | "cn-north-1" | "cn-northwest-1" | "eu-central-1" | "eu-north-1" | "eu-south-1" | "eu-west-1" | "eu-west-2" | "eu-west-3" | "me-south-1" | "sa-east-1" | "us-east-2" | "us-gov-east-1" | "us-gov-west-1" | "us-west-1" | "us-west-2";

export interface CreateBucketConfiguration {
    
    LocationConstraint?: BucketLocationConstraint | string;
}
export declare namespace CreateBucketConfiguration {
    
    const filterSensitiveLog: (obj: CreateBucketConfiguration) => any;
}
export declare type ObjectOwnership = "BucketOwnerEnforced" | "BucketOwnerPreferred" | "ObjectWriter";
export interface CreateBucketRequest {
    
    ACL?: BucketCannedACL | string;
    
    Bucket: string | undefined;
    
    CreateBucketConfiguration?: CreateBucketConfiguration;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWrite?: string;
    
    GrantWriteACP?: string;
    
    ObjectLockEnabledForBucket?: boolean;
    
    ObjectOwnership?: ObjectOwnership | string;
}
export declare namespace CreateBucketRequest {
    
    const filterSensitiveLog: (obj: CreateBucketRequest) => any;
}
export interface CreateMultipartUploadOutput {
    
    AbortDate?: Date;
    
    AbortRuleId?: string;
    
    Bucket?: string;
    
    Key?: string;
    
    UploadId?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace CreateMultipartUploadOutput {
    
    const filterSensitiveLog: (obj: CreateMultipartUploadOutput) => any;
}
export interface CreateMultipartUploadRequest {
    
    ACL?: ObjectCannedACL | string;
    
    Bucket: string | undefined;
    
    CacheControl?: string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentType?: string;
    
    Expires?: Date;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWriteACP?: string;
    
    Key: string | undefined;
    
    Metadata?: {
        [key: string]: string;
    };
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    StorageClass?: StorageClass | string;
    
    WebsiteRedirectLocation?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestPayer?: RequestPayer | string;
    
    Tagging?: string;
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
    
    ExpectedBucketOwner?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace CreateMultipartUploadRequest {
    
    const filterSensitiveLog: (obj: CreateMultipartUploadRequest) => any;
}
export interface DeleteBucketRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketRequest) => any;
}
export interface DeleteBucketAnalyticsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketAnalyticsConfigurationRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketAnalyticsConfigurationRequest) => any;
}
export interface DeleteBucketCorsRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketCorsRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketCorsRequest) => any;
}
export interface DeleteBucketEncryptionRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketEncryptionRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketEncryptionRequest) => any;
}
export interface DeleteBucketIntelligentTieringConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
}
export declare namespace DeleteBucketIntelligentTieringConfigurationRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketIntelligentTieringConfigurationRequest) => any;
}
export interface DeleteBucketInventoryConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketInventoryConfigurationRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketInventoryConfigurationRequest) => any;
}
export interface DeleteBucketLifecycleRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketLifecycleRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketLifecycleRequest) => any;
}
export interface DeleteBucketMetricsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketMetricsConfigurationRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketMetricsConfigurationRequest) => any;
}
export interface DeleteBucketOwnershipControlsRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketOwnershipControlsRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketOwnershipControlsRequest) => any;
}
export interface DeleteBucketPolicyRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketPolicyRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketPolicyRequest) => any;
}
export interface DeleteBucketReplicationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketReplicationRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketReplicationRequest) => any;
}
export interface DeleteBucketTaggingRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketTaggingRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketTaggingRequest) => any;
}
export interface DeleteBucketWebsiteRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteBucketWebsiteRequest {
    
    const filterSensitiveLog: (obj: DeleteBucketWebsiteRequest) => any;
}
export interface DeleteObjectOutput {
    
    DeleteMarker?: boolean;
    
    VersionId?: string;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace DeleteObjectOutput {
    
    const filterSensitiveLog: (obj: DeleteObjectOutput) => any;
}
export interface DeleteObjectRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    MFA?: string;
    
    VersionId?: string;
    
    RequestPayer?: RequestPayer | string;
    
    BypassGovernanceRetention?: boolean;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteObjectRequest {
    
    const filterSensitiveLog: (obj: DeleteObjectRequest) => any;
}

export interface DeletedObject {
    
    Key?: string;
    
    VersionId?: string;
    
    DeleteMarker?: boolean;
    
    DeleteMarkerVersionId?: string;
}
export declare namespace DeletedObject {
    
    const filterSensitiveLog: (obj: DeletedObject) => any;
}

export interface _Error {
    
    Key?: string;
    
    VersionId?: string;
    
    Code?: string;
    
    Message?: string;
}
export declare namespace _Error {
    
    const filterSensitiveLog: (obj: _Error) => any;
}
export interface DeleteObjectsOutput {
    
    Deleted?: DeletedObject[];
    
    RequestCharged?: RequestCharged | string;
    
    Errors?: _Error[];
}
export declare namespace DeleteObjectsOutput {
    
    const filterSensitiveLog: (obj: DeleteObjectsOutput) => any;
}

export interface ObjectIdentifier {
    
    Key: string | undefined;
    
    VersionId?: string;
}
export declare namespace ObjectIdentifier {
    
    const filterSensitiveLog: (obj: ObjectIdentifier) => any;
}

export interface Delete {
    
    Objects: ObjectIdentifier[] | undefined;
    
    Quiet?: boolean;
}
export declare namespace Delete {
    
    const filterSensitiveLog: (obj: Delete) => any;
}
export interface DeleteObjectsRequest {
    
    Bucket: string | undefined;
    
    Delete: Delete | undefined;
    
    MFA?: string;
    
    RequestPayer?: RequestPayer | string;
    
    BypassGovernanceRetention?: boolean;
    
    ExpectedBucketOwner?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace DeleteObjectsRequest {
    
    const filterSensitiveLog: (obj: DeleteObjectsRequest) => any;
}
export interface DeleteObjectTaggingOutput {
    
    VersionId?: string;
}
export declare namespace DeleteObjectTaggingOutput {
    
    const filterSensitiveLog: (obj: DeleteObjectTaggingOutput) => any;
}
export interface DeleteObjectTaggingRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeleteObjectTaggingRequest {
    
    const filterSensitiveLog: (obj: DeleteObjectTaggingRequest) => any;
}
export interface DeletePublicAccessBlockRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace DeletePublicAccessBlockRequest {
    
    const filterSensitiveLog: (obj: DeletePublicAccessBlockRequest) => any;
}
export interface GetBucketAccelerateConfigurationOutput {
    
    Status?: BucketAccelerateStatus | string;
}
export declare namespace GetBucketAccelerateConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketAccelerateConfigurationOutput) => any;
}
export interface GetBucketAccelerateConfigurationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketAccelerateConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketAccelerateConfigurationRequest) => any;
}
export interface GetBucketAclOutput {
    
    Owner?: Owner;
    
    Grants?: Grant[];
}
export declare namespace GetBucketAclOutput {
    
    const filterSensitiveLog: (obj: GetBucketAclOutput) => any;
}
export interface GetBucketAclRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketAclRequest {
    
    const filterSensitiveLog: (obj: GetBucketAclRequest) => any;
}

export interface Tag {
    
    Key: string | undefined;
    
    Value: string | undefined;
}
export declare namespace Tag {
    
    const filterSensitiveLog: (obj: Tag) => any;
}

export interface AnalyticsAndOperator {
    
    Prefix?: string;
    
    Tags?: Tag[];
}
export declare namespace AnalyticsAndOperator {
    
    const filterSensitiveLog: (obj: AnalyticsAndOperator) => any;
}

export declare type AnalyticsFilter = AnalyticsFilter.AndMember | AnalyticsFilter.PrefixMember | AnalyticsFilter.TagMember | AnalyticsFilter.$UnknownMember;
export declare namespace AnalyticsFilter {
    
    interface PrefixMember {
        Prefix: string;
        Tag?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface TagMember {
        Prefix?: never;
        Tag: Tag;
        And?: never;
        $unknown?: never;
    }
    
    interface AndMember {
        Prefix?: never;
        Tag?: never;
        And: AnalyticsAndOperator;
        $unknown?: never;
    }
    interface $UnknownMember {
        Prefix?: never;
        Tag?: never;
        And?: never;
        $unknown: [
            string,
            any
        ];
    }
    interface Visitor<T> {
        Prefix: (value: string) => T;
        Tag: (value: Tag) => T;
        And: (value: AnalyticsAndOperator) => T;
        _: (name: string, value: any) => T;
    }
    const visit: <T>(value: AnalyticsFilter, visitor: Visitor<T>) => T;
    
    const filterSensitiveLog: (obj: AnalyticsFilter) => any;
}
export declare type AnalyticsS3ExportFileFormat = "CSV";

export interface AnalyticsS3BucketDestination {
    
    Format: AnalyticsS3ExportFileFormat | string | undefined;
    
    BucketAccountId?: string;
    
    Bucket: string | undefined;
    
    Prefix?: string;
}
export declare namespace AnalyticsS3BucketDestination {
    
    const filterSensitiveLog: (obj: AnalyticsS3BucketDestination) => any;
}

export interface AnalyticsExportDestination {
    
    S3BucketDestination: AnalyticsS3BucketDestination | undefined;
}
export declare namespace AnalyticsExportDestination {
    
    const filterSensitiveLog: (obj: AnalyticsExportDestination) => any;
}
export declare type StorageClassAnalysisSchemaVersion = "V_1";

export interface StorageClassAnalysisDataExport {
    
    OutputSchemaVersion: StorageClassAnalysisSchemaVersion | string | undefined;
    
    Destination: AnalyticsExportDestination | undefined;
}
export declare namespace StorageClassAnalysisDataExport {
    
    const filterSensitiveLog: (obj: StorageClassAnalysisDataExport) => any;
}

export interface StorageClassAnalysis {
    
    DataExport?: StorageClassAnalysisDataExport;
}
export declare namespace StorageClassAnalysis {
    
    const filterSensitiveLog: (obj: StorageClassAnalysis) => any;
}

export interface AnalyticsConfiguration {
    
    Id: string | undefined;
    
    Filter?: AnalyticsFilter;
    
    StorageClassAnalysis: StorageClassAnalysis | undefined;
}
export declare namespace AnalyticsConfiguration {
    
    const filterSensitiveLog: (obj: AnalyticsConfiguration) => any;
}
export interface GetBucketAnalyticsConfigurationOutput {
    
    AnalyticsConfiguration?: AnalyticsConfiguration;
}
export declare namespace GetBucketAnalyticsConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketAnalyticsConfigurationOutput) => any;
}
export interface GetBucketAnalyticsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketAnalyticsConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketAnalyticsConfigurationRequest) => any;
}

export interface CORSRule {
    
    ID?: string;
    
    AllowedHeaders?: string[];
    
    AllowedMethods: string[] | undefined;
    
    AllowedOrigins: string[] | undefined;
    
    ExposeHeaders?: string[];
    
    MaxAgeSeconds?: number;
}
export declare namespace CORSRule {
    
    const filterSensitiveLog: (obj: CORSRule) => any;
}
export interface GetBucketCorsOutput {
    
    CORSRules?: CORSRule[];
}
export declare namespace GetBucketCorsOutput {
    
    const filterSensitiveLog: (obj: GetBucketCorsOutput) => any;
}
export interface GetBucketCorsRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketCorsRequest {
    
    const filterSensitiveLog: (obj: GetBucketCorsRequest) => any;
}

export interface ServerSideEncryptionByDefault {
    
    SSEAlgorithm: ServerSideEncryption | string | undefined;
    
    KMSMasterKeyID?: string;
}
export declare namespace ServerSideEncryptionByDefault {
    
    const filterSensitiveLog: (obj: ServerSideEncryptionByDefault) => any;
}

export interface ServerSideEncryptionRule {
    
    ApplyServerSideEncryptionByDefault?: ServerSideEncryptionByDefault;
    
    BucketKeyEnabled?: boolean;
}
export declare namespace ServerSideEncryptionRule {
    
    const filterSensitiveLog: (obj: ServerSideEncryptionRule) => any;
}

export interface ServerSideEncryptionConfiguration {
    
    Rules: ServerSideEncryptionRule[] | undefined;
}
export declare namespace ServerSideEncryptionConfiguration {
    
    const filterSensitiveLog: (obj: ServerSideEncryptionConfiguration) => any;
}
export interface GetBucketEncryptionOutput {
    
    ServerSideEncryptionConfiguration?: ServerSideEncryptionConfiguration;
}
export declare namespace GetBucketEncryptionOutput {
    
    const filterSensitiveLog: (obj: GetBucketEncryptionOutput) => any;
}
export interface GetBucketEncryptionRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketEncryptionRequest {
    
    const filterSensitiveLog: (obj: GetBucketEncryptionRequest) => any;
}

export interface IntelligentTieringAndOperator {
    
    Prefix?: string;
    
    Tags?: Tag[];
}
export declare namespace IntelligentTieringAndOperator {
    
    const filterSensitiveLog: (obj: IntelligentTieringAndOperator) => any;
}

export interface IntelligentTieringFilter {
    
    Prefix?: string;
    
    Tag?: Tag;
    
    And?: IntelligentTieringAndOperator;
}
export declare namespace IntelligentTieringFilter {
    
    const filterSensitiveLog: (obj: IntelligentTieringFilter) => any;
}
export declare type IntelligentTieringStatus = "Disabled" | "Enabled";
export declare type IntelligentTieringAccessTier = "ARCHIVE_ACCESS" | "DEEP_ARCHIVE_ACCESS";

export interface Tiering {
    
    Days: number | undefined;
    
    AccessTier: IntelligentTieringAccessTier | string | undefined;
}
export declare namespace Tiering {
    
    const filterSensitiveLog: (obj: Tiering) => any;
}

export interface IntelligentTieringConfiguration {
    
    Id: string | undefined;
    
    Filter?: IntelligentTieringFilter;
    
    Status: IntelligentTieringStatus | string | undefined;
    
    Tierings: Tiering[] | undefined;
}
export declare namespace IntelligentTieringConfiguration {
    
    const filterSensitiveLog: (obj: IntelligentTieringConfiguration) => any;
}
export interface GetBucketIntelligentTieringConfigurationOutput {
    
    IntelligentTieringConfiguration?: IntelligentTieringConfiguration;
}
export declare namespace GetBucketIntelligentTieringConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketIntelligentTieringConfigurationOutput) => any;
}
export interface GetBucketIntelligentTieringConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
}
export declare namespace GetBucketIntelligentTieringConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketIntelligentTieringConfigurationRequest) => any;
}

export interface SSEKMS {
    
    KeyId: string | undefined;
}
export declare namespace SSEKMS {
    
    const filterSensitiveLog: (obj: SSEKMS) => any;
}

export interface SSES3 {
}
export declare namespace SSES3 {
    
    const filterSensitiveLog: (obj: SSES3) => any;
}

export interface InventoryEncryption {
    
    SSES3?: SSES3;
    
    SSEKMS?: SSEKMS;
}
export declare namespace InventoryEncryption {
    
    const filterSensitiveLog: (obj: InventoryEncryption) => any;
}
export declare type InventoryFormat = "CSV" | "ORC" | "Parquet";

export interface InventoryS3BucketDestination {
    
    AccountId?: string;
    
    Bucket: string | undefined;
    
    Format: InventoryFormat | string | undefined;
    
    Prefix?: string;
    
    Encryption?: InventoryEncryption;
}
export declare namespace InventoryS3BucketDestination {
    
    const filterSensitiveLog: (obj: InventoryS3BucketDestination) => any;
}

export interface InventoryDestination {
    
    S3BucketDestination: InventoryS3BucketDestination | undefined;
}
export declare namespace InventoryDestination {
    
    const filterSensitiveLog: (obj: InventoryDestination) => any;
}

export interface InventoryFilter {
    
    Prefix: string | undefined;
}
export declare namespace InventoryFilter {
    
    const filterSensitiveLog: (obj: InventoryFilter) => any;
}
export declare type InventoryIncludedObjectVersions = "All" | "Current";
export declare type InventoryOptionalField = "BucketKeyStatus" | "ChecksumAlgorithm" | "ETag" | "EncryptionStatus" | "IntelligentTieringAccessTier" | "IsMultipartUploaded" | "LastModifiedDate" | "ObjectLockLegalHoldStatus" | "ObjectLockMode" | "ObjectLockRetainUntilDate" | "ReplicationStatus" | "Size" | "StorageClass";
export declare type InventoryFrequency = "Daily" | "Weekly";

export interface InventorySchedule {
    
    Frequency: InventoryFrequency | string | undefined;
}
export declare namespace InventorySchedule {
    
    const filterSensitiveLog: (obj: InventorySchedule) => any;
}

export interface InventoryConfiguration {
    
    Destination: InventoryDestination | undefined;
    
    IsEnabled: boolean | undefined;
    
    Filter?: InventoryFilter;
    
    Id: string | undefined;
    
    IncludedObjectVersions: InventoryIncludedObjectVersions | string | undefined;
    
    OptionalFields?: (InventoryOptionalField | string)[];
    
    Schedule: InventorySchedule | undefined;
}
export declare namespace InventoryConfiguration {
    
    const filterSensitiveLog: (obj: InventoryConfiguration) => any;
}
export interface GetBucketInventoryConfigurationOutput {
    
    InventoryConfiguration?: InventoryConfiguration;
}
export declare namespace GetBucketInventoryConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketInventoryConfigurationOutput) => any;
}
export interface GetBucketInventoryConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketInventoryConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketInventoryConfigurationRequest) => any;
}

export interface LifecycleExpiration {
    
    Date?: Date;
    
    Days?: number;
    
    ExpiredObjectDeleteMarker?: boolean;
}
export declare namespace LifecycleExpiration {
    
    const filterSensitiveLog: (obj: LifecycleExpiration) => any;
}

export interface LifecycleRuleAndOperator {
    
    Prefix?: string;
    
    Tags?: Tag[];
    
    ObjectSizeGreaterThan?: number;
    
    ObjectSizeLessThan?: number;
}
export declare namespace LifecycleRuleAndOperator {
    
    const filterSensitiveLog: (obj: LifecycleRuleAndOperator) => any;
}

export declare type LifecycleRuleFilter = LifecycleRuleFilter.AndMember | LifecycleRuleFilter.ObjectSizeGreaterThanMember | LifecycleRuleFilter.ObjectSizeLessThanMember | LifecycleRuleFilter.PrefixMember | LifecycleRuleFilter.TagMember | LifecycleRuleFilter.$UnknownMember;
export declare namespace LifecycleRuleFilter {
    
    interface PrefixMember {
        Prefix: string;
        Tag?: never;
        ObjectSizeGreaterThan?: never;
        ObjectSizeLessThan?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface TagMember {
        Prefix?: never;
        Tag: Tag;
        ObjectSizeGreaterThan?: never;
        ObjectSizeLessThan?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface ObjectSizeGreaterThanMember {
        Prefix?: never;
        Tag?: never;
        ObjectSizeGreaterThan: number;
        ObjectSizeLessThan?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface ObjectSizeLessThanMember {
        Prefix?: never;
        Tag?: never;
        ObjectSizeGreaterThan?: never;
        ObjectSizeLessThan: number;
        And?: never;
        $unknown?: never;
    }
    
    interface AndMember {
        Prefix?: never;
        Tag?: never;
        ObjectSizeGreaterThan?: never;
        ObjectSizeLessThan?: never;
        And: LifecycleRuleAndOperator;
        $unknown?: never;
    }
    interface $UnknownMember {
        Prefix?: never;
        Tag?: never;
        ObjectSizeGreaterThan?: never;
        ObjectSizeLessThan?: never;
        And?: never;
        $unknown: [
            string,
            any
        ];
    }
    interface Visitor<T> {
        Prefix: (value: string) => T;
        Tag: (value: Tag) => T;
        ObjectSizeGreaterThan: (value: number) => T;
        ObjectSizeLessThan: (value: number) => T;
        And: (value: LifecycleRuleAndOperator) => T;
        _: (name: string, value: any) => T;
    }
    const visit: <T>(value: LifecycleRuleFilter, visitor: Visitor<T>) => T;
    
    const filterSensitiveLog: (obj: LifecycleRuleFilter) => any;
}

export interface NoncurrentVersionExpiration {
    
    NoncurrentDays?: number;
    
    NewerNoncurrentVersions?: number;
}
export declare namespace NoncurrentVersionExpiration {
    
    const filterSensitiveLog: (obj: NoncurrentVersionExpiration) => any;
}
export declare type TransitionStorageClass = "DEEP_ARCHIVE" | "GLACIER" | "GLACIER_IR" | "INTELLIGENT_TIERING" | "ONEZONE_IA" | "STANDARD_IA";

export interface NoncurrentVersionTransition {
    
    NoncurrentDays?: number;
    
    StorageClass?: TransitionStorageClass | string;
    
    NewerNoncurrentVersions?: number;
}
export declare namespace NoncurrentVersionTransition {
    
    const filterSensitiveLog: (obj: NoncurrentVersionTransition) => any;
}
export declare type ExpirationStatus = "Disabled" | "Enabled";

export interface Transition {
    
    Date?: Date;
    
    Days?: number;
    
    StorageClass?: TransitionStorageClass | string;
}
export declare namespace Transition {
    
    const filterSensitiveLog: (obj: Transition) => any;
}

export interface LifecycleRule {
    
    Expiration?: LifecycleExpiration;
    
    ID?: string;
    
    Prefix?: string;
    
    Filter?: LifecycleRuleFilter;
    
    Status: ExpirationStatus | string | undefined;
    
    Transitions?: Transition[];
    
    NoncurrentVersionTransitions?: NoncurrentVersionTransition[];
    
    NoncurrentVersionExpiration?: NoncurrentVersionExpiration;
    
    AbortIncompleteMultipartUpload?: AbortIncompleteMultipartUpload;
}
export declare namespace LifecycleRule {
    
    const filterSensitiveLog: (obj: LifecycleRule) => any;
}
export interface GetBucketLifecycleConfigurationOutput {
    
    Rules?: LifecycleRule[];
}
export declare namespace GetBucketLifecycleConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketLifecycleConfigurationOutput) => any;
}
export interface GetBucketLifecycleConfigurationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketLifecycleConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketLifecycleConfigurationRequest) => any;
}
export interface GetBucketLocationOutput {
    
    LocationConstraint?: BucketLocationConstraint | string;
}
export declare namespace GetBucketLocationOutput {
    
    const filterSensitiveLog: (obj: GetBucketLocationOutput) => any;
}
export interface GetBucketLocationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketLocationRequest {
    
    const filterSensitiveLog: (obj: GetBucketLocationRequest) => any;
}
export declare type BucketLogsPermission = "FULL_CONTROL" | "READ" | "WRITE";

export interface TargetGrant {
    
    Grantee?: Grantee;
    
    Permission?: BucketLogsPermission | string;
}
export declare namespace TargetGrant {
    
    const filterSensitiveLog: (obj: TargetGrant) => any;
}

export interface LoggingEnabled {
    
    TargetBucket: string | undefined;
    
    TargetGrants?: TargetGrant[];
    
    TargetPrefix: string | undefined;
}
export declare namespace LoggingEnabled {
    
    const filterSensitiveLog: (obj: LoggingEnabled) => any;
}
export interface GetBucketLoggingOutput {
    
    LoggingEnabled?: LoggingEnabled;
}
export declare namespace GetBucketLoggingOutput {
    
    const filterSensitiveLog: (obj: GetBucketLoggingOutput) => any;
}
export interface GetBucketLoggingRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketLoggingRequest {
    
    const filterSensitiveLog: (obj: GetBucketLoggingRequest) => any;
}

export interface MetricsAndOperator {
    
    Prefix?: string;
    
    Tags?: Tag[];
    
    AccessPointArn?: string;
}
export declare namespace MetricsAndOperator {
    
    const filterSensitiveLog: (obj: MetricsAndOperator) => any;
}

export declare type MetricsFilter = MetricsFilter.AccessPointArnMember | MetricsFilter.AndMember | MetricsFilter.PrefixMember | MetricsFilter.TagMember | MetricsFilter.$UnknownMember;
export declare namespace MetricsFilter {
    
    interface PrefixMember {
        Prefix: string;
        Tag?: never;
        AccessPointArn?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface TagMember {
        Prefix?: never;
        Tag: Tag;
        AccessPointArn?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface AccessPointArnMember {
        Prefix?: never;
        Tag?: never;
        AccessPointArn: string;
        And?: never;
        $unknown?: never;
    }
    
    interface AndMember {
        Prefix?: never;
        Tag?: never;
        AccessPointArn?: never;
        And: MetricsAndOperator;
        $unknown?: never;
    }
    interface $UnknownMember {
        Prefix?: never;
        Tag?: never;
        AccessPointArn?: never;
        And?: never;
        $unknown: [
            string,
            any
        ];
    }
    interface Visitor<T> {
        Prefix: (value: string) => T;
        Tag: (value: Tag) => T;
        AccessPointArn: (value: string) => T;
        And: (value: MetricsAndOperator) => T;
        _: (name: string, value: any) => T;
    }
    const visit: <T>(value: MetricsFilter, visitor: Visitor<T>) => T;
    
    const filterSensitiveLog: (obj: MetricsFilter) => any;
}

export interface MetricsConfiguration {
    
    Id: string | undefined;
    
    Filter?: MetricsFilter;
}
export declare namespace MetricsConfiguration {
    
    const filterSensitiveLog: (obj: MetricsConfiguration) => any;
}
export interface GetBucketMetricsConfigurationOutput {
    
    MetricsConfiguration?: MetricsConfiguration;
}
export declare namespace GetBucketMetricsConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetBucketMetricsConfigurationOutput) => any;
}
export interface GetBucketMetricsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketMetricsConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketMetricsConfigurationRequest) => any;
}
export interface GetBucketNotificationConfigurationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketNotificationConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetBucketNotificationConfigurationRequest) => any;
}

export interface EventBridgeConfiguration {
}
export declare namespace EventBridgeConfiguration {
    
    const filterSensitiveLog: (obj: EventBridgeConfiguration) => any;
}
export declare type Event = "s3:IntelligentTiering" | "s3:LifecycleExpiration:*" | "s3:LifecycleExpiration:Delete" | "s3:LifecycleExpiration:DeleteMarkerCreated" | "s3:LifecycleTransition" | "s3:ObjectAcl:Put" | "s3:ObjectCreated:*" | "s3:ObjectCreated:CompleteMultipartUpload" | "s3:ObjectCreated:Copy" | "s3:ObjectCreated:Post" | "s3:ObjectCreated:Put" | "s3:ObjectRemoved:*" | "s3:ObjectRemoved:Delete" | "s3:ObjectRemoved:DeleteMarkerCreated" | "s3:ObjectRestore:*" | "s3:ObjectRestore:Completed" | "s3:ObjectRestore:Delete" | "s3:ObjectRestore:Post" | "s3:ObjectTagging:*" | "s3:ObjectTagging:Delete" | "s3:ObjectTagging:Put" | "s3:ReducedRedundancyLostObject" | "s3:Replication:*" | "s3:Replication:OperationFailedReplication" | "s3:Replication:OperationMissedThreshold" | "s3:Replication:OperationNotTracked" | "s3:Replication:OperationReplicatedAfterThreshold";
export declare type FilterRuleName = "prefix" | "suffix";

export interface FilterRule {
    
    Name?: FilterRuleName | string;
    
    Value?: string;
}
export declare namespace FilterRule {
    
    const filterSensitiveLog: (obj: FilterRule) => any;
}

export interface S3KeyFilter {
    
    FilterRules?: FilterRule[];
}
export declare namespace S3KeyFilter {
    
    const filterSensitiveLog: (obj: S3KeyFilter) => any;
}

export interface NotificationConfigurationFilter {
    
    Key?: S3KeyFilter;
}
export declare namespace NotificationConfigurationFilter {
    
    const filterSensitiveLog: (obj: NotificationConfigurationFilter) => any;
}

export interface LambdaFunctionConfiguration {
    
    Id?: string;
    
    LambdaFunctionArn: string | undefined;
    
    Events: (Event | string)[] | undefined;
    
    Filter?: NotificationConfigurationFilter;
}
export declare namespace LambdaFunctionConfiguration {
    
    const filterSensitiveLog: (obj: LambdaFunctionConfiguration) => any;
}

export interface QueueConfiguration {
    
    Id?: string;
    
    QueueArn: string | undefined;
    
    Events: (Event | string)[] | undefined;
    
    Filter?: NotificationConfigurationFilter;
}
export declare namespace QueueConfiguration {
    
    const filterSensitiveLog: (obj: QueueConfiguration) => any;
}

export interface TopicConfiguration {
    
    Id?: string;
    
    TopicArn: string | undefined;
    
    Events: (Event | string)[] | undefined;
    
    Filter?: NotificationConfigurationFilter;
}
export declare namespace TopicConfiguration {
    
    const filterSensitiveLog: (obj: TopicConfiguration) => any;
}

export interface NotificationConfiguration {
    
    TopicConfigurations?: TopicConfiguration[];
    
    QueueConfigurations?: QueueConfiguration[];
    
    LambdaFunctionConfigurations?: LambdaFunctionConfiguration[];
    
    EventBridgeConfiguration?: EventBridgeConfiguration;
}
export declare namespace NotificationConfiguration {
    
    const filterSensitiveLog: (obj: NotificationConfiguration) => any;
}

export interface OwnershipControlsRule {
    
    ObjectOwnership: ObjectOwnership | string | undefined;
}
export declare namespace OwnershipControlsRule {
    
    const filterSensitiveLog: (obj: OwnershipControlsRule) => any;
}

export interface OwnershipControls {
    
    Rules: OwnershipControlsRule[] | undefined;
}
export declare namespace OwnershipControls {
    
    const filterSensitiveLog: (obj: OwnershipControls) => any;
}
export interface GetBucketOwnershipControlsOutput {
    
    OwnershipControls?: OwnershipControls;
}
export declare namespace GetBucketOwnershipControlsOutput {
    
    const filterSensitiveLog: (obj: GetBucketOwnershipControlsOutput) => any;
}
export interface GetBucketOwnershipControlsRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketOwnershipControlsRequest {
    
    const filterSensitiveLog: (obj: GetBucketOwnershipControlsRequest) => any;
}
export interface GetBucketPolicyOutput {
    
    Policy?: string;
}
export declare namespace GetBucketPolicyOutput {
    
    const filterSensitiveLog: (obj: GetBucketPolicyOutput) => any;
}
export interface GetBucketPolicyRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketPolicyRequest {
    
    const filterSensitiveLog: (obj: GetBucketPolicyRequest) => any;
}

export interface PolicyStatus {
    
    IsPublic?: boolean;
}
export declare namespace PolicyStatus {
    
    const filterSensitiveLog: (obj: PolicyStatus) => any;
}
export interface GetBucketPolicyStatusOutput {
    
    PolicyStatus?: PolicyStatus;
}
export declare namespace GetBucketPolicyStatusOutput {
    
    const filterSensitiveLog: (obj: GetBucketPolicyStatusOutput) => any;
}
export interface GetBucketPolicyStatusRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketPolicyStatusRequest {
    
    const filterSensitiveLog: (obj: GetBucketPolicyStatusRequest) => any;
}
export declare type DeleteMarkerReplicationStatus = "Disabled" | "Enabled";

export interface DeleteMarkerReplication {
    
    Status?: DeleteMarkerReplicationStatus | string;
}
export declare namespace DeleteMarkerReplication {
    
    const filterSensitiveLog: (obj: DeleteMarkerReplication) => any;
}

export interface EncryptionConfiguration {
    
    ReplicaKmsKeyID?: string;
}
export declare namespace EncryptionConfiguration {
    
    const filterSensitiveLog: (obj: EncryptionConfiguration) => any;
}

export interface ReplicationTimeValue {
    
    Minutes?: number;
}
export declare namespace ReplicationTimeValue {
    
    const filterSensitiveLog: (obj: ReplicationTimeValue) => any;
}
export declare type MetricsStatus = "Disabled" | "Enabled";

export interface Metrics {
    
    Status: MetricsStatus | string | undefined;
    
    EventThreshold?: ReplicationTimeValue;
}
export declare namespace Metrics {
    
    const filterSensitiveLog: (obj: Metrics) => any;
}
export declare type ReplicationTimeStatus = "Disabled" | "Enabled";

export interface ReplicationTime {
    
    Status: ReplicationTimeStatus | string | undefined;
    
    Time: ReplicationTimeValue | undefined;
}
export declare namespace ReplicationTime {
    
    const filterSensitiveLog: (obj: ReplicationTime) => any;
}

export interface Destination {
    
    Bucket: string | undefined;
    
    Account?: string;
    
    StorageClass?: StorageClass | string;
    
    AccessControlTranslation?: AccessControlTranslation;
    
    EncryptionConfiguration?: EncryptionConfiguration;
    
    ReplicationTime?: ReplicationTime;
    
    Metrics?: Metrics;
}
export declare namespace Destination {
    
    const filterSensitiveLog: (obj: Destination) => any;
}
export declare type ExistingObjectReplicationStatus = "Disabled" | "Enabled";

export interface ExistingObjectReplication {
    
    Status: ExistingObjectReplicationStatus | string | undefined;
}
export declare namespace ExistingObjectReplication {
    
    const filterSensitiveLog: (obj: ExistingObjectReplication) => any;
}

export interface ReplicationRuleAndOperator {
    
    Prefix?: string;
    
    Tags?: Tag[];
}
export declare namespace ReplicationRuleAndOperator {
    
    const filterSensitiveLog: (obj: ReplicationRuleAndOperator) => any;
}

export declare type ReplicationRuleFilter = ReplicationRuleFilter.AndMember | ReplicationRuleFilter.PrefixMember | ReplicationRuleFilter.TagMember | ReplicationRuleFilter.$UnknownMember;
export declare namespace ReplicationRuleFilter {
    
    interface PrefixMember {
        Prefix: string;
        Tag?: never;
        And?: never;
        $unknown?: never;
    }
    
    interface TagMember {
        Prefix?: never;
        Tag: Tag;
        And?: never;
        $unknown?: never;
    }
    
    interface AndMember {
        Prefix?: never;
        Tag?: never;
        And: ReplicationRuleAndOperator;
        $unknown?: never;
    }
    interface $UnknownMember {
        Prefix?: never;
        Tag?: never;
        And?: never;
        $unknown: [
            string,
            any
        ];
    }
    interface Visitor<T> {
        Prefix: (value: string) => T;
        Tag: (value: Tag) => T;
        And: (value: ReplicationRuleAndOperator) => T;
        _: (name: string, value: any) => T;
    }
    const visit: <T>(value: ReplicationRuleFilter, visitor: Visitor<T>) => T;
    
    const filterSensitiveLog: (obj: ReplicationRuleFilter) => any;
}
export declare type ReplicaModificationsStatus = "Disabled" | "Enabled";

export interface ReplicaModifications {
    
    Status: ReplicaModificationsStatus | string | undefined;
}
export declare namespace ReplicaModifications {
    
    const filterSensitiveLog: (obj: ReplicaModifications) => any;
}
export declare type SseKmsEncryptedObjectsStatus = "Disabled" | "Enabled";

export interface SseKmsEncryptedObjects {
    
    Status: SseKmsEncryptedObjectsStatus | string | undefined;
}
export declare namespace SseKmsEncryptedObjects {
    
    const filterSensitiveLog: (obj: SseKmsEncryptedObjects) => any;
}

export interface SourceSelectionCriteria {
    
    SseKmsEncryptedObjects?: SseKmsEncryptedObjects;
    
    ReplicaModifications?: ReplicaModifications;
}
export declare namespace SourceSelectionCriteria {
    
    const filterSensitiveLog: (obj: SourceSelectionCriteria) => any;
}
export declare type ReplicationRuleStatus = "Disabled" | "Enabled";

export interface ReplicationRule {
    
    ID?: string;
    
    Priority?: number;
    
    Prefix?: string;
    
    Filter?: ReplicationRuleFilter;
    
    Status: ReplicationRuleStatus | string | undefined;
    
    SourceSelectionCriteria?: SourceSelectionCriteria;
    
    ExistingObjectReplication?: ExistingObjectReplication;
    
    Destination: Destination | undefined;
    
    DeleteMarkerReplication?: DeleteMarkerReplication;
}
export declare namespace ReplicationRule {
    
    const filterSensitiveLog: (obj: ReplicationRule) => any;
}

export interface ReplicationConfiguration {
    
    Role: string | undefined;
    
    Rules: ReplicationRule[] | undefined;
}
export declare namespace ReplicationConfiguration {
    
    const filterSensitiveLog: (obj: ReplicationConfiguration) => any;
}
export interface GetBucketReplicationOutput {
    
    ReplicationConfiguration?: ReplicationConfiguration;
}
export declare namespace GetBucketReplicationOutput {
    
    const filterSensitiveLog: (obj: GetBucketReplicationOutput) => any;
}
export interface GetBucketReplicationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketReplicationRequest {
    
    const filterSensitiveLog: (obj: GetBucketReplicationRequest) => any;
}
export declare type Payer = "BucketOwner" | "Requester";
export interface GetBucketRequestPaymentOutput {
    
    Payer?: Payer | string;
}
export declare namespace GetBucketRequestPaymentOutput {
    
    const filterSensitiveLog: (obj: GetBucketRequestPaymentOutput) => any;
}
export interface GetBucketRequestPaymentRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketRequestPaymentRequest {
    
    const filterSensitiveLog: (obj: GetBucketRequestPaymentRequest) => any;
}
export interface GetBucketTaggingOutput {
    
    TagSet: Tag[] | undefined;
}
export declare namespace GetBucketTaggingOutput {
    
    const filterSensitiveLog: (obj: GetBucketTaggingOutput) => any;
}
export interface GetBucketTaggingRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketTaggingRequest {
    
    const filterSensitiveLog: (obj: GetBucketTaggingRequest) => any;
}
export declare type MFADeleteStatus = "Disabled" | "Enabled";
export declare type BucketVersioningStatus = "Enabled" | "Suspended";
export interface GetBucketVersioningOutput {
    
    Status?: BucketVersioningStatus | string;
    
    MFADelete?: MFADeleteStatus | string;
}
export declare namespace GetBucketVersioningOutput {
    
    const filterSensitiveLog: (obj: GetBucketVersioningOutput) => any;
}
export interface GetBucketVersioningRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketVersioningRequest {
    
    const filterSensitiveLog: (obj: GetBucketVersioningRequest) => any;
}

export interface ErrorDocument {
    
    Key: string | undefined;
}
export declare namespace ErrorDocument {
    
    const filterSensitiveLog: (obj: ErrorDocument) => any;
}

export interface IndexDocument {
    
    Suffix: string | undefined;
}
export declare namespace IndexDocument {
    
    const filterSensitiveLog: (obj: IndexDocument) => any;
}
export declare type Protocol = "http" | "https";

export interface RedirectAllRequestsTo {
    
    HostName: string | undefined;
    
    Protocol?: Protocol | string;
}
export declare namespace RedirectAllRequestsTo {
    
    const filterSensitiveLog: (obj: RedirectAllRequestsTo) => any;
}

export interface Condition {
    
    HttpErrorCodeReturnedEquals?: string;
    
    KeyPrefixEquals?: string;
}
export declare namespace Condition {
    
    const filterSensitiveLog: (obj: Condition) => any;
}

export interface Redirect {
    
    HostName?: string;
    
    HttpRedirectCode?: string;
    
    Protocol?: Protocol | string;
    
    ReplaceKeyPrefixWith?: string;
    
    ReplaceKeyWith?: string;
}
export declare namespace Redirect {
    
    const filterSensitiveLog: (obj: Redirect) => any;
}

export interface RoutingRule {
    
    Condition?: Condition;
    
    Redirect: Redirect | undefined;
}
export declare namespace RoutingRule {
    
    const filterSensitiveLog: (obj: RoutingRule) => any;
}
export interface GetBucketWebsiteOutput {
    
    RedirectAllRequestsTo?: RedirectAllRequestsTo;
    
    IndexDocument?: IndexDocument;
    
    ErrorDocument?: ErrorDocument;
    
    RoutingRules?: RoutingRule[];
}
export declare namespace GetBucketWebsiteOutput {
    
    const filterSensitiveLog: (obj: GetBucketWebsiteOutput) => any;
}
export interface GetBucketWebsiteRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetBucketWebsiteRequest {
    
    const filterSensitiveLog: (obj: GetBucketWebsiteRequest) => any;
}
export declare type ReplicationStatus = "COMPLETE" | "FAILED" | "PENDING" | "REPLICA";
export interface GetObjectOutput {
    
    Body?: Readable | ReadableStream | Blob;
    
    DeleteMarker?: boolean;
    
    AcceptRanges?: string;
    
    Expiration?: string;
    
    Restore?: string;
    
    LastModified?: Date;
    
    ContentLength?: number;
    
    ETag?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    MissingMeta?: number;
    
    VersionId?: string;
    
    CacheControl?: string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentRange?: string;
    
    ContentType?: string;
    
    Expires?: Date;
    
    WebsiteRedirectLocation?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    Metadata?: {
        [key: string]: string;
    };
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    BucketKeyEnabled?: boolean;
    
    StorageClass?: StorageClass | string;
    
    RequestCharged?: RequestCharged | string;
    
    ReplicationStatus?: ReplicationStatus | string;
    
    PartsCount?: number;
    
    TagCount?: number;
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
}
export declare namespace GetObjectOutput {
    
    const filterSensitiveLog: (obj: GetObjectOutput) => any;
}
export declare enum ChecksumMode {
    ENABLED = "ENABLED"
}
export interface GetObjectRequest {
    
    Bucket: string | undefined;
    
    IfMatch?: string;
    
    IfModifiedSince?: Date;
    
    IfNoneMatch?: string;
    
    IfUnmodifiedSince?: Date;
    
    Key: string | undefined;
    
    Range?: string;
    
    ResponseCacheControl?: string;
    
    ResponseContentDisposition?: string;
    
    ResponseContentEncoding?: string;
    
    ResponseContentLanguage?: string;
    
    ResponseContentType?: string;
    
    ResponseExpires?: Date;
    
    VersionId?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    PartNumber?: number;
    
    ExpectedBucketOwner?: string;
    
    ChecksumMode?: ChecksumMode | string;
}
export declare namespace GetObjectRequest {
    
    const filterSensitiveLog: (obj: GetObjectRequest) => any;
}

export declare class InvalidObjectState extends __BaseException {
    readonly name: "InvalidObjectState";
    readonly $fault: "client";
    StorageClass?: StorageClass | string;
    AccessTier?: IntelligentTieringAccessTier | string;
    
    constructor(opts: __ExceptionOptionType<InvalidObjectState, __BaseException>);
}

export declare class NoSuchKey extends __BaseException {
    readonly name: "NoSuchKey";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<NoSuchKey, __BaseException>);
}
export interface GetObjectAclOutput {
    
    Owner?: Owner;
    
    Grants?: Grant[];
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace GetObjectAclOutput {
    
    const filterSensitiveLog: (obj: GetObjectAclOutput) => any;
}
export interface GetObjectAclRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetObjectAclRequest {
    
    const filterSensitiveLog: (obj: GetObjectAclRequest) => any;
}

export interface Checksum {
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
}
export declare namespace Checksum {
    
    const filterSensitiveLog: (obj: Checksum) => any;
}

export interface ObjectPart {
    
    PartNumber?: number;
    
    Size?: number;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
}
export declare namespace ObjectPart {
    
    const filterSensitiveLog: (obj: ObjectPart) => any;
}

export interface GetObjectAttributesParts {
    
    TotalPartsCount?: number;
    
    PartNumberMarker?: string;
    
    NextPartNumberMarker?: string;
    
    MaxParts?: number;
    
    IsTruncated?: boolean;
    
    Parts?: ObjectPart[];
}
export declare namespace GetObjectAttributesParts {
    
    const filterSensitiveLog: (obj: GetObjectAttributesParts) => any;
}
export interface GetObjectAttributesOutput {
    
    DeleteMarker?: boolean;
    
    LastModified?: Date;
    
    VersionId?: string;
    
    RequestCharged?: RequestCharged | string;
    
    ETag?: string;
    
    Checksum?: Checksum;
    
    ObjectParts?: GetObjectAttributesParts;
    
    StorageClass?: StorageClass | string;
    
    ObjectSize?: number;
}
export declare namespace GetObjectAttributesOutput {
    
    const filterSensitiveLog: (obj: GetObjectAttributesOutput) => any;
}
export declare enum ObjectAttributes {
    CHECKSUM = "Checksum",
    ETAG = "ETag",
    OBJECT_PARTS = "ObjectParts",
    OBJECT_SIZE = "ObjectSize",
    STORAGE_CLASS = "StorageClass"
}
export interface GetObjectAttributesRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    MaxParts?: number;
    
    PartNumberMarker?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
    
    ObjectAttributes: (ObjectAttributes | string)[] | undefined;
}
export declare namespace GetObjectAttributesRequest {
    
    const filterSensitiveLog: (obj: GetObjectAttributesRequest) => any;
}

export interface ObjectLockLegalHold {
    
    Status?: ObjectLockLegalHoldStatus | string;
}
export declare namespace ObjectLockLegalHold {
    
    const filterSensitiveLog: (obj: ObjectLockLegalHold) => any;
}
export interface GetObjectLegalHoldOutput {
    
    LegalHold?: ObjectLockLegalHold;
}
export declare namespace GetObjectLegalHoldOutput {
    
    const filterSensitiveLog: (obj: GetObjectLegalHoldOutput) => any;
}
export interface GetObjectLegalHoldRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetObjectLegalHoldRequest {
    
    const filterSensitiveLog: (obj: GetObjectLegalHoldRequest) => any;
}
export declare type ObjectLockEnabled = "Enabled";
export declare type ObjectLockRetentionMode = "COMPLIANCE" | "GOVERNANCE";

export interface DefaultRetention {
    
    Mode?: ObjectLockRetentionMode | string;
    
    Days?: number;
    
    Years?: number;
}
export declare namespace DefaultRetention {
    
    const filterSensitiveLog: (obj: DefaultRetention) => any;
}

export interface ObjectLockRule {
    
    DefaultRetention?: DefaultRetention;
}
export declare namespace ObjectLockRule {
    
    const filterSensitiveLog: (obj: ObjectLockRule) => any;
}

export interface ObjectLockConfiguration {
    
    ObjectLockEnabled?: ObjectLockEnabled | string;
    
    Rule?: ObjectLockRule;
}
export declare namespace ObjectLockConfiguration {
    
    const filterSensitiveLog: (obj: ObjectLockConfiguration) => any;
}
export interface GetObjectLockConfigurationOutput {
    
    ObjectLockConfiguration?: ObjectLockConfiguration;
}
export declare namespace GetObjectLockConfigurationOutput {
    
    const filterSensitiveLog: (obj: GetObjectLockConfigurationOutput) => any;
}
export interface GetObjectLockConfigurationRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetObjectLockConfigurationRequest {
    
    const filterSensitiveLog: (obj: GetObjectLockConfigurationRequest) => any;
}

export interface ObjectLockRetention {
    
    Mode?: ObjectLockRetentionMode | string;
    
    RetainUntilDate?: Date;
}
export declare namespace ObjectLockRetention {
    
    const filterSensitiveLog: (obj: ObjectLockRetention) => any;
}
export interface GetObjectRetentionOutput {
    
    Retention?: ObjectLockRetention;
}
export declare namespace GetObjectRetentionOutput {
    
    const filterSensitiveLog: (obj: GetObjectRetentionOutput) => any;
}
export interface GetObjectRetentionRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetObjectRetentionRequest {
    
    const filterSensitiveLog: (obj: GetObjectRetentionRequest) => any;
}
export interface GetObjectTaggingOutput {
    
    VersionId?: string;
    
    TagSet: Tag[] | undefined;
}
export declare namespace GetObjectTaggingOutput {
    
    const filterSensitiveLog: (obj: GetObjectTaggingOutput) => any;
}
export interface GetObjectTaggingRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    VersionId?: string;
    
    ExpectedBucketOwner?: string;
    
    RequestPayer?: RequestPayer | string;
}
export declare namespace GetObjectTaggingRequest {
    
    const filterSensitiveLog: (obj: GetObjectTaggingRequest) => any;
}
export interface GetObjectTorrentOutput {
    
    Body?: Readable | ReadableStream | Blob;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace GetObjectTorrentOutput {
    
    const filterSensitiveLog: (obj: GetObjectTorrentOutput) => any;
}
export interface GetObjectTorrentRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetObjectTorrentRequest {
    
    const filterSensitiveLog: (obj: GetObjectTorrentRequest) => any;
}

export interface PublicAccessBlockConfiguration {
    
    BlockPublicAcls?: boolean;
    
    IgnorePublicAcls?: boolean;
    
    BlockPublicPolicy?: boolean;
    
    RestrictPublicBuckets?: boolean;
}
export declare namespace PublicAccessBlockConfiguration {
    
    const filterSensitiveLog: (obj: PublicAccessBlockConfiguration) => any;
}
export interface GetPublicAccessBlockOutput {
    
    PublicAccessBlockConfiguration?: PublicAccessBlockConfiguration;
}
export declare namespace GetPublicAccessBlockOutput {
    
    const filterSensitiveLog: (obj: GetPublicAccessBlockOutput) => any;
}
export interface GetPublicAccessBlockRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace GetPublicAccessBlockRequest {
    
    const filterSensitiveLog: (obj: GetPublicAccessBlockRequest) => any;
}
export interface HeadBucketRequest {
    
    Bucket: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace HeadBucketRequest {
    
    const filterSensitiveLog: (obj: HeadBucketRequest) => any;
}

export declare class NotFound extends __BaseException {
    readonly name: "NotFound";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<NotFound, __BaseException>);
}
export declare type ArchiveStatus = "ARCHIVE_ACCESS" | "DEEP_ARCHIVE_ACCESS";
export interface HeadObjectOutput {
    
    DeleteMarker?: boolean;
    
    AcceptRanges?: string;
    
    Expiration?: string;
    
    Restore?: string;
    
    ArchiveStatus?: ArchiveStatus | string;
    
    LastModified?: Date;
    
    ContentLength?: number;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    ETag?: string;
    
    MissingMeta?: number;
    
    VersionId?: string;
    
    CacheControl?: string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentType?: string;
    
    Expires?: Date;
    
    WebsiteRedirectLocation?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    Metadata?: {
        [key: string]: string;
    };
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    BucketKeyEnabled?: boolean;
    
    StorageClass?: StorageClass | string;
    
    RequestCharged?: RequestCharged | string;
    
    ReplicationStatus?: ReplicationStatus | string;
    
    PartsCount?: number;
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
}
export declare namespace HeadObjectOutput {
    
    const filterSensitiveLog: (obj: HeadObjectOutput) => any;
}
export interface HeadObjectRequest {
    
    Bucket: string | undefined;
    
    IfMatch?: string;
    
    IfModifiedSince?: Date;
    
    IfNoneMatch?: string;
    
    IfUnmodifiedSince?: Date;
    
    Key: string | undefined;
    
    Range?: string;
    
    VersionId?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    RequestPayer?: RequestPayer | string;
    
    PartNumber?: number;
    
    ExpectedBucketOwner?: string;
    
    ChecksumMode?: ChecksumMode | string;
}
export declare namespace HeadObjectRequest {
    
    const filterSensitiveLog: (obj: HeadObjectRequest) => any;
}
export interface ListBucketAnalyticsConfigurationsOutput {
    
    IsTruncated?: boolean;
    
    ContinuationToken?: string;
    
    NextContinuationToken?: string;
    
    AnalyticsConfigurationList?: AnalyticsConfiguration[];
}
export declare namespace ListBucketAnalyticsConfigurationsOutput {
    
    const filterSensitiveLog: (obj: ListBucketAnalyticsConfigurationsOutput) => any;
}
export interface ListBucketAnalyticsConfigurationsRequest {
    
    Bucket: string | undefined;
    
    ContinuationToken?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListBucketAnalyticsConfigurationsRequest {
    
    const filterSensitiveLog: (obj: ListBucketAnalyticsConfigurationsRequest) => any;
}
export interface ListBucketIntelligentTieringConfigurationsOutput {
    
    IsTruncated?: boolean;
    
    ContinuationToken?: string;
    
    NextContinuationToken?: string;
    
    IntelligentTieringConfigurationList?: IntelligentTieringConfiguration[];
}
export declare namespace ListBucketIntelligentTieringConfigurationsOutput {
    
    const filterSensitiveLog: (obj: ListBucketIntelligentTieringConfigurationsOutput) => any;
}
export interface ListBucketIntelligentTieringConfigurationsRequest {
    
    Bucket: string | undefined;
    
    ContinuationToken?: string;
}
export declare namespace ListBucketIntelligentTieringConfigurationsRequest {
    
    const filterSensitiveLog: (obj: ListBucketIntelligentTieringConfigurationsRequest) => any;
}
export interface ListBucketInventoryConfigurationsOutput {
    
    ContinuationToken?: string;
    
    InventoryConfigurationList?: InventoryConfiguration[];
    
    IsTruncated?: boolean;
    
    NextContinuationToken?: string;
}
export declare namespace ListBucketInventoryConfigurationsOutput {
    
    const filterSensitiveLog: (obj: ListBucketInventoryConfigurationsOutput) => any;
}
export interface ListBucketInventoryConfigurationsRequest {
    
    Bucket: string | undefined;
    
    ContinuationToken?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListBucketInventoryConfigurationsRequest {
    
    const filterSensitiveLog: (obj: ListBucketInventoryConfigurationsRequest) => any;
}
export interface ListBucketMetricsConfigurationsOutput {
    
    IsTruncated?: boolean;
    
    ContinuationToken?: string;
    
    NextContinuationToken?: string;
    
    MetricsConfigurationList?: MetricsConfiguration[];
}
export declare namespace ListBucketMetricsConfigurationsOutput {
    
    const filterSensitiveLog: (obj: ListBucketMetricsConfigurationsOutput) => any;
}
export interface ListBucketMetricsConfigurationsRequest {
    
    Bucket: string | undefined;
    
    ContinuationToken?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListBucketMetricsConfigurationsRequest {
    
    const filterSensitiveLog: (obj: ListBucketMetricsConfigurationsRequest) => any;
}

export interface Bucket {
    
    Name?: string;
    
    CreationDate?: Date;
}
export declare namespace Bucket {
    
    const filterSensitiveLog: (obj: Bucket) => any;
}
export interface ListBucketsOutput {
    
    Buckets?: Bucket[];
    
    Owner?: Owner;
}
export declare namespace ListBucketsOutput {
    
    const filterSensitiveLog: (obj: ListBucketsOutput) => any;
}

export interface CommonPrefix {
    
    Prefix?: string;
}
export declare namespace CommonPrefix {
    
    const filterSensitiveLog: (obj: CommonPrefix) => any;
}
export declare type EncodingType = "url";

export interface Initiator {
    
    ID?: string;
    
    DisplayName?: string;
}
export declare namespace Initiator {
    
    const filterSensitiveLog: (obj: Initiator) => any;
}

export interface MultipartUpload {
    
    UploadId?: string;
    
    Key?: string;
    
    Initiated?: Date;
    
    StorageClass?: StorageClass | string;
    
    Owner?: Owner;
    
    Initiator?: Initiator;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace MultipartUpload {
    
    const filterSensitiveLog: (obj: MultipartUpload) => any;
}
export interface ListMultipartUploadsOutput {
    
    Bucket?: string;
    
    KeyMarker?: string;
    
    UploadIdMarker?: string;
    
    NextKeyMarker?: string;
    
    Prefix?: string;
    
    Delimiter?: string;
    
    NextUploadIdMarker?: string;
    
    MaxUploads?: number;
    
    IsTruncated?: boolean;
    
    Uploads?: MultipartUpload[];
    
    CommonPrefixes?: CommonPrefix[];
    
    EncodingType?: EncodingType | string;
}
export declare namespace ListMultipartUploadsOutput {
    
    const filterSensitiveLog: (obj: ListMultipartUploadsOutput) => any;
}
export interface ListMultipartUploadsRequest {
    
    Bucket: string | undefined;
    
    Delimiter?: string;
    
    EncodingType?: EncodingType | string;
    
    KeyMarker?: string;
    
    MaxUploads?: number;
    
    Prefix?: string;
    
    UploadIdMarker?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListMultipartUploadsRequest {
    
    const filterSensitiveLog: (obj: ListMultipartUploadsRequest) => any;
}
export declare type ObjectStorageClass = "DEEP_ARCHIVE" | "GLACIER" | "GLACIER_IR" | "INTELLIGENT_TIERING" | "ONEZONE_IA" | "OUTPOSTS" | "REDUCED_REDUNDANCY" | "STANDARD" | "STANDARD_IA";

export interface _Object {
    
    Key?: string;
    
    LastModified?: Date;
    
    ETag?: string;
    
    ChecksumAlgorithm?: (ChecksumAlgorithm | string)[];
    
    Size?: number;
    
    StorageClass?: ObjectStorageClass | string;
    
    Owner?: Owner;
}
export declare namespace _Object {
    
    const filterSensitiveLog: (obj: _Object) => any;
}
export interface ListObjectsOutput {
    
    IsTruncated?: boolean;
    
    Marker?: string;
    
    NextMarker?: string;
    
    Contents?: _Object[];
    
    Name?: string;
    
    Prefix?: string;
    
    Delimiter?: string;
    
    MaxKeys?: number;
    
    CommonPrefixes?: CommonPrefix[];
    
    EncodingType?: EncodingType | string;
}
export declare namespace ListObjectsOutput {
    
    const filterSensitiveLog: (obj: ListObjectsOutput) => any;
}
export interface ListObjectsRequest {
    
    Bucket: string | undefined;
    
    Delimiter?: string;
    
    EncodingType?: EncodingType | string;
    
    Marker?: string;
    
    MaxKeys?: number;
    
    Prefix?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListObjectsRequest {
    
    const filterSensitiveLog: (obj: ListObjectsRequest) => any;
}

export declare class NoSuchBucket extends __BaseException {
    readonly name: "NoSuchBucket";
    readonly $fault: "client";
    
    constructor(opts: __ExceptionOptionType<NoSuchBucket, __BaseException>);
}
export interface ListObjectsV2Output {
    
    IsTruncated?: boolean;
    
    Contents?: _Object[];
    
    Name?: string;
    
    Prefix?: string;
    
    Delimiter?: string;
    
    MaxKeys?: number;
    
    CommonPrefixes?: CommonPrefix[];
    
    EncodingType?: EncodingType | string;
    
    KeyCount?: number;
    
    ContinuationToken?: string;
    
    NextContinuationToken?: string;
    
    StartAfter?: string;
}
export declare namespace ListObjectsV2Output {
    
    const filterSensitiveLog: (obj: ListObjectsV2Output) => any;
}
export interface ListObjectsV2Request {
    
    Bucket: string | undefined;
    
    Delimiter?: string;
    
    EncodingType?: EncodingType | string;
    
    MaxKeys?: number;
    
    Prefix?: string;
    
    ContinuationToken?: string;
    
    FetchOwner?: boolean;
    
    StartAfter?: string;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListObjectsV2Request {
    
    const filterSensitiveLog: (obj: ListObjectsV2Request) => any;
}

export interface DeleteMarkerEntry {
    
    Owner?: Owner;
    
    Key?: string;
    
    VersionId?: string;
    
    IsLatest?: boolean;
    
    LastModified?: Date;
}
export declare namespace DeleteMarkerEntry {
    
    const filterSensitiveLog: (obj: DeleteMarkerEntry) => any;
}
export declare type ObjectVersionStorageClass = "STANDARD";

export interface ObjectVersion {
    
    ETag?: string;
    
    ChecksumAlgorithm?: (ChecksumAlgorithm | string)[];
    
    Size?: number;
    
    StorageClass?: ObjectVersionStorageClass | string;
    
    Key?: string;
    
    VersionId?: string;
    
    IsLatest?: boolean;
    
    LastModified?: Date;
    
    Owner?: Owner;
}
export declare namespace ObjectVersion {
    
    const filterSensitiveLog: (obj: ObjectVersion) => any;
}
export interface ListObjectVersionsOutput {
    
    IsTruncated?: boolean;
    
    KeyMarker?: string;
    
    VersionIdMarker?: string;
    
    NextKeyMarker?: string;
    
    NextVersionIdMarker?: string;
    
    Versions?: ObjectVersion[];
    
    DeleteMarkers?: DeleteMarkerEntry[];
    
    Name?: string;
    
    Prefix?: string;
    
    Delimiter?: string;
    
    MaxKeys?: number;
    
    CommonPrefixes?: CommonPrefix[];
    
    EncodingType?: EncodingType | string;
}
export declare namespace ListObjectVersionsOutput {
    
    const filterSensitiveLog: (obj: ListObjectVersionsOutput) => any;
}
export interface ListObjectVersionsRequest {
    
    Bucket: string | undefined;
    
    Delimiter?: string;
    
    EncodingType?: EncodingType | string;
    
    KeyMarker?: string;
    
    MaxKeys?: number;
    
    Prefix?: string;
    
    VersionIdMarker?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace ListObjectVersionsRequest {
    
    const filterSensitiveLog: (obj: ListObjectVersionsRequest) => any;
}

export interface Part {
    
    PartNumber?: number;
    
    LastModified?: Date;
    
    ETag?: string;
    
    Size?: number;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
}
export declare namespace Part {
    
    const filterSensitiveLog: (obj: Part) => any;
}
export interface ListPartsOutput {
    
    AbortDate?: Date;
    
    AbortRuleId?: string;
    
    Bucket?: string;
    
    Key?: string;
    
    UploadId?: string;
    
    PartNumberMarker?: string;
    
    NextPartNumberMarker?: string;
    
    MaxParts?: number;
    
    IsTruncated?: boolean;
    
    Parts?: Part[];
    
    Initiator?: Initiator;
    
    Owner?: Owner;
    
    StorageClass?: StorageClass | string;
    
    RequestCharged?: RequestCharged | string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace ListPartsOutput {
    
    const filterSensitiveLog: (obj: ListPartsOutput) => any;
}
export interface ListPartsRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    MaxParts?: number;
    
    PartNumberMarker?: string;
    
    UploadId: string | undefined;
    
    RequestPayer?: RequestPayer | string;
    
    ExpectedBucketOwner?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
}
export declare namespace ListPartsRequest {
    
    const filterSensitiveLog: (obj: ListPartsRequest) => any;
}
export interface PutBucketAccelerateConfigurationRequest {
    
    Bucket: string | undefined;
    
    AccelerateConfiguration: AccelerateConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
}
export declare namespace PutBucketAccelerateConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketAccelerateConfigurationRequest) => any;
}
export interface PutBucketAclRequest {
    
    ACL?: BucketCannedACL | string;
    
    AccessControlPolicy?: AccessControlPolicy;
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWrite?: string;
    
    GrantWriteACP?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketAclRequest {
    
    const filterSensitiveLog: (obj: PutBucketAclRequest) => any;
}
export interface PutBucketAnalyticsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    AnalyticsConfiguration: AnalyticsConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketAnalyticsConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketAnalyticsConfigurationRequest) => any;
}

export interface CORSConfiguration {
    
    CORSRules: CORSRule[] | undefined;
}
export declare namespace CORSConfiguration {
    
    const filterSensitiveLog: (obj: CORSConfiguration) => any;
}
export interface PutBucketCorsRequest {
    
    Bucket: string | undefined;
    
    CORSConfiguration: CORSConfiguration | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketCorsRequest {
    
    const filterSensitiveLog: (obj: PutBucketCorsRequest) => any;
}
export interface PutBucketEncryptionRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ServerSideEncryptionConfiguration: ServerSideEncryptionConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketEncryptionRequest {
    
    const filterSensitiveLog: (obj: PutBucketEncryptionRequest) => any;
}
export interface PutBucketIntelligentTieringConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    IntelligentTieringConfiguration: IntelligentTieringConfiguration | undefined;
}
export declare namespace PutBucketIntelligentTieringConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketIntelligentTieringConfigurationRequest) => any;
}
export interface PutBucketInventoryConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    InventoryConfiguration: InventoryConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketInventoryConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketInventoryConfigurationRequest) => any;
}

export interface BucketLifecycleConfiguration {
    
    Rules: LifecycleRule[] | undefined;
}
export declare namespace BucketLifecycleConfiguration {
    
    const filterSensitiveLog: (obj: BucketLifecycleConfiguration) => any;
}
export interface PutBucketLifecycleConfigurationRequest {
    
    Bucket: string | undefined;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    LifecycleConfiguration?: BucketLifecycleConfiguration;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketLifecycleConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketLifecycleConfigurationRequest) => any;
}

export interface BucketLoggingStatus {
    
    LoggingEnabled?: LoggingEnabled;
}
export declare namespace BucketLoggingStatus {
    
    const filterSensitiveLog: (obj: BucketLoggingStatus) => any;
}
export interface PutBucketLoggingRequest {
    
    Bucket: string | undefined;
    
    BucketLoggingStatus: BucketLoggingStatus | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketLoggingRequest {
    
    const filterSensitiveLog: (obj: PutBucketLoggingRequest) => any;
}
export interface PutBucketMetricsConfigurationRequest {
    
    Bucket: string | undefined;
    
    Id: string | undefined;
    
    MetricsConfiguration: MetricsConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketMetricsConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketMetricsConfigurationRequest) => any;
}
export interface PutBucketNotificationConfigurationRequest {
    
    Bucket: string | undefined;
    
    NotificationConfiguration: NotificationConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
    
    SkipDestinationValidation?: boolean;
}
export declare namespace PutBucketNotificationConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutBucketNotificationConfigurationRequest) => any;
}
export interface PutBucketOwnershipControlsRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ExpectedBucketOwner?: string;
    
    OwnershipControls: OwnershipControls | undefined;
}
export declare namespace PutBucketOwnershipControlsRequest {
    
    const filterSensitiveLog: (obj: PutBucketOwnershipControlsRequest) => any;
}
export interface PutBucketPolicyRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ConfirmRemoveSelfBucketAccess?: boolean;
    
    Policy: string | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketPolicyRequest {
    
    const filterSensitiveLog: (obj: PutBucketPolicyRequest) => any;
}
export interface PutBucketReplicationRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ReplicationConfiguration: ReplicationConfiguration | undefined;
    
    Token?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketReplicationRequest {
    
    const filterSensitiveLog: (obj: PutBucketReplicationRequest) => any;
}

export interface RequestPaymentConfiguration {
    
    Payer: Payer | string | undefined;
}
export declare namespace RequestPaymentConfiguration {
    
    const filterSensitiveLog: (obj: RequestPaymentConfiguration) => any;
}
export interface PutBucketRequestPaymentRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    RequestPaymentConfiguration: RequestPaymentConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketRequestPaymentRequest {
    
    const filterSensitiveLog: (obj: PutBucketRequestPaymentRequest) => any;
}

export interface Tagging {
    
    TagSet: Tag[] | undefined;
}
export declare namespace Tagging {
    
    const filterSensitiveLog: (obj: Tagging) => any;
}
export interface PutBucketTaggingRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    Tagging: Tagging | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketTaggingRequest {
    
    const filterSensitiveLog: (obj: PutBucketTaggingRequest) => any;
}
export declare type MFADelete = "Disabled" | "Enabled";

export interface VersioningConfiguration {
    
    MFADelete?: MFADelete | string;
    
    Status?: BucketVersioningStatus | string;
}
export declare namespace VersioningConfiguration {
    
    const filterSensitiveLog: (obj: VersioningConfiguration) => any;
}
export interface PutBucketVersioningRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    MFA?: string;
    
    VersioningConfiguration: VersioningConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketVersioningRequest {
    
    const filterSensitiveLog: (obj: PutBucketVersioningRequest) => any;
}

export interface WebsiteConfiguration {
    
    ErrorDocument?: ErrorDocument;
    
    IndexDocument?: IndexDocument;
    
    RedirectAllRequestsTo?: RedirectAllRequestsTo;
    
    RoutingRules?: RoutingRule[];
}
export declare namespace WebsiteConfiguration {
    
    const filterSensitiveLog: (obj: WebsiteConfiguration) => any;
}
export interface PutBucketWebsiteRequest {
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    WebsiteConfiguration: WebsiteConfiguration | undefined;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutBucketWebsiteRequest {
    
    const filterSensitiveLog: (obj: PutBucketWebsiteRequest) => any;
}
export interface PutObjectOutput {
    
    Expiration?: string;
    
    ETag?: string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    VersionId?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace PutObjectOutput {
    
    const filterSensitiveLog: (obj: PutObjectOutput) => any;
}
export interface PutObjectRequest {
    
    ACL?: ObjectCannedACL | string;
    
    Body?: Readable | ReadableStream | Blob;
    
    Bucket: string | undefined;
    
    CacheControl?: string;
    
    ContentDisposition?: string;
    
    ContentEncoding?: string;
    
    ContentLanguage?: string;
    
    ContentLength?: number;
    
    ContentMD5?: string;
    
    ContentType?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ChecksumCRC32?: string;
    
    ChecksumCRC32C?: string;
    
    ChecksumSHA1?: string;
    
    ChecksumSHA256?: string;
    
    Expires?: Date;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWriteACP?: string;
    
    Key: string | undefined;
    
    Metadata?: {
        [key: string]: string;
    };
    
    ServerSideEncryption?: ServerSideEncryption | string;
    
    StorageClass?: StorageClass | string;
    
    WebsiteRedirectLocation?: string;
    
    SSECustomerAlgorithm?: string;
    
    SSECustomerKey?: string;
    
    SSECustomerKeyMD5?: string;
    
    SSEKMSKeyId?: string;
    
    SSEKMSEncryptionContext?: string;
    
    BucketKeyEnabled?: boolean;
    
    RequestPayer?: RequestPayer | string;
    
    Tagging?: string;
    
    ObjectLockMode?: ObjectLockMode | string;
    
    ObjectLockRetainUntilDate?: Date;
    
    ObjectLockLegalHoldStatus?: ObjectLockLegalHoldStatus | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutObjectRequest {
    
    const filterSensitiveLog: (obj: PutObjectRequest) => any;
}
export interface PutObjectAclOutput {
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace PutObjectAclOutput {
    
    const filterSensitiveLog: (obj: PutObjectAclOutput) => any;
}
export interface PutObjectAclRequest {
    
    ACL?: ObjectCannedACL | string;
    
    AccessControlPolicy?: AccessControlPolicy;
    
    Bucket: string | undefined;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    GrantFullControl?: string;
    
    GrantRead?: string;
    
    GrantReadACP?: string;
    
    GrantWrite?: string;
    
    GrantWriteACP?: string;
    
    Key: string | undefined;
    
    RequestPayer?: RequestPayer | string;
    
    VersionId?: string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutObjectAclRequest {
    
    const filterSensitiveLog: (obj: PutObjectAclRequest) => any;
}
export interface PutObjectLegalHoldOutput {
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace PutObjectLegalHoldOutput {
    
    const filterSensitiveLog: (obj: PutObjectLegalHoldOutput) => any;
}
export interface PutObjectLegalHoldRequest {
    
    Bucket: string | undefined;
    
    Key: string | undefined;
    
    LegalHold?: ObjectLockLegalHold;
    
    RequestPayer?: RequestPayer | string;
    
    VersionId?: string;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutObjectLegalHoldRequest {
    
    const filterSensitiveLog: (obj: PutObjectLegalHoldRequest) => any;
}
export interface PutObjectLockConfigurationOutput {
    
    RequestCharged?: RequestCharged | string;
}
export declare namespace PutObjectLockConfigurationOutput {
    
    const filterSensitiveLog: (obj: PutObjectLockConfigurationOutput) => any;
}
export interface PutObjectLockConfigurationRequest {
    
    Bucket: string | undefined;
    
    ObjectLockConfiguration?: ObjectLockConfiguration;
    
    RequestPayer?: RequestPayer | string;
    
    Token?: string;
    
    ContentMD5?: string;
    
    ChecksumAlgorithm?: ChecksumAlgorithm | string;
    
    ExpectedBucketOwner?: string;
}
export declare namespace PutObjectLockConfigurationRequest {
    
    const filterSensitiveLog: (obj: PutObjectLockConfigurationRequest) => any;
}
