/// <reference types="node" />
import { NodeHttpHandler as RequestHandler } from "@aws-sdk/node-http-handler";
import { HashConstructor as __HashConstructor } from "@aws-sdk/types";
import { S3ClientConfig } from "./S3Client";
/**
 * @internal
 */
export declare const getRuntimeConfig: (config: S3ClientConfig) => {
    runtime: string;
    defaultsMode: import("@aws-sdk/types").Provider<import("@aws-sdk/smithy-client").ResolvedDefaultsMode>;
    base64Decoder: import("@aws-sdk/types").Decoder;
    base64Encoder: import("@aws-sdk/types").Encoder;
    bodyLengthChecker: import("@aws-sdk/types").BodyLengthCalculator;
    credentialDefaultProvider: (input: any) => import("@aws-sdk/types").Provider<import("@aws-sdk/types").Credentials>;
    defaultUserAgentProvider: import("@aws-sdk/types").Provider<import("@aws-sdk/types").UserAgent>;
    eventStreamSerdeProvider: import("@aws-sdk/types").EventStreamSerdeProvider;
    getAwsChunkedEncodingStream: import("@aws-sdk/types").GetAwsChunkedEncodingStream<any> | import("@aws-sdk/types").GetAwsChunkedEncodingStream<import("stream").Readable>;
    maxAttempts: number | import("@aws-sdk/types").Provider<number>;
    md5: __HashConstructor;
    region: string | import("@aws-sdk/types").Provider<string>;
    requestHandler: (import("@aws-sdk/types").RequestHandler<any, any, import("@aws-sdk/types").HttpHandlerOptions> & import("@aws-sdk/protocol-http").HttpHandler) | RequestHandler;
    retryMode: string | import("@aws-sdk/types").Provider<string>;
    sha1: __HashConstructor;
    sha256: __HashConstructor;
    streamCollector: import("@aws-sdk/types").StreamCollector;
    streamHasher: import("@aws-sdk/types").StreamHasher<import("stream").Readable> | import("@aws-sdk/types").StreamHasher<Blob>;
    useArnRegion: boolean | import("@aws-sdk/types").Provider<boolean>;
    useDualstackEndpoint: boolean | import("@aws-sdk/types").Provider<boolean>;
    useFipsEndpoint: boolean | import("@aws-sdk/types").Provider<boolean>;
    utf8Decoder: import("@aws-sdk/types").Decoder;
    utf8Encoder: import("@aws-sdk/types").Encoder;
    apiVersion: string;
    urlParser: import("@aws-sdk/types").UrlParser;
    disableHostPrefix: boolean;
    logger: import("@aws-sdk/types").Logger;
    serviceId: string;
    regionInfoProvider: import("@aws-sdk/types").RegionInfoProvider;
    signingEscapePath: boolean;
    endpoint?: string | import("@aws-sdk/types").Endpoint | import("@aws-sdk/types").Provider<import("@aws-sdk/types").Endpoint> | undefined;
    tls?: boolean | undefined;
    retryStrategy?: import("@aws-sdk/types").RetryStrategy | undefined;
    credentials?: import("@aws-sdk/types").Credentials | import("@aws-sdk/types").Provider<import("@aws-sdk/types").Credentials> | undefined;
    signer?: import("@aws-sdk/types").RequestSigner | import("@aws-sdk/types").Provider<import("@aws-sdk/types").RequestSigner> | undefined;
    systemClockOffset?: number | undefined;
    signingRegion?: string | undefined;
    signerConstructor: (new (options: import("@aws-sdk/signature-v4").SignatureV4Init & import("@aws-sdk/signature-v4").SignatureV4CryptoInit) => import("@aws-sdk/types").RequestSigner) | typeof import("@aws-sdk/signature-v4-multi-region").SignatureV4MultiRegion;
    bucketEndpoint?: boolean | undefined;
    forcePathStyle?: boolean | undefined;
    useAccelerateEndpoint?: boolean | undefined;
    disableMultiregionAccessPoints?: boolean | import("@aws-sdk/types").Provider<boolean> | undefined;
    customUserAgent?: string | import("@aws-sdk/types").UserAgent | undefined;
};
