import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getSsecPlugin } from "@aws-sdk/middleware-ssec";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { SelectObjectContentOutput, SelectObjectContentRequest } from "../models/models_1";
import { deserializeAws_restXmlSelectObjectContentCommand, serializeAws_restXmlSelectObjectContentCommand, } from "../protocols/Aws_restXml";
var SelectObjectContentCommand = (function (_super) {
    __extends(SelectObjectContentCommand, _super);
    function SelectObjectContentCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    SelectObjectContentCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getSsecPlugin(configuration));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "SelectObjectContentCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: SelectObjectContentRequest.filterSensitiveLog,
            outputFilterSensitiveLog: SelectObjectContentOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    SelectObjectContentCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlSelectObjectContentCommand(input, context);
    };
    SelectObjectContentCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlSelectObjectContentCommand(output, context);
    };
    return SelectObjectContentCommand;
}($Command));
export { SelectObjectContentCommand };
