import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { RestoreObjectOutput, RestoreObjectRequest } from "../models/models_1";
import { deserializeAws_restXmlRestoreObjectCommand, serializeAws_restXmlRestoreObjectCommand, } from "../protocols/Aws_restXml";
var RestoreObjectCommand = (function (_super) {
    __extends(RestoreObjectCommand, _super);
    function RestoreObjectCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    RestoreObjectCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: false,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "RestoreObjectCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: RestoreObjectRequest.filterSensitiveLog,
            outputFilterSensitiveLog: RestoreObjectOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    RestoreObjectCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlRestoreObjectCommand(input, context);
    };
    RestoreObjectCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlRestoreObjectCommand(output, context);
    };
    return RestoreObjectCommand;
}($Command));
export { RestoreObjectCommand };
