import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutPublicAccessBlockRequest } from "../models/models_1";
import { deserializeAws_restXmlPutPublicAccessBlockCommand, serializeAws_restXmlPutPublicAccessBlockCommand, } from "../protocols/Aws_restXml";
var PutPublicAccessBlockCommand = (function (_super) {
    __extends(PutPublicAccessBlockCommand, _super);
    function PutPublicAccessBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutPublicAccessBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutPublicAccessBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutPublicAccessBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutPublicAccessBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutPublicAccessBlockCommand(input, context);
    };
    PutPublicAccessBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutPublicAccessBlockCommand(output, context);
    };
    return PutPublicAccessBlockCommand;
}($Command));
export { PutPublicAccessBlockCommand };
