import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutObjectRetentionOutput, PutObjectRetentionRequest } from "../models/models_1";
import { deserializeAws_restXmlPutObjectRetentionCommand, serializeAws_restXmlPutObjectRetentionCommand, } from "../protocols/Aws_restXml";
var PutObjectRetentionCommand = (function (_super) {
    __extends(PutObjectRetentionCommand, _super);
    function PutObjectRetentionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutObjectRetentionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutObjectRetentionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutObjectRetentionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PutObjectRetentionOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutObjectRetentionCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutObjectRetentionCommand(input, context);
    };
    PutObjectRetentionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutObjectRetentionCommand(output, context);
    };
    return PutObjectRetentionCommand;
}($Command));
export { PutObjectRetentionCommand };
