import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutObjectLockConfigurationOutput, PutObjectLockConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutObjectLockConfigurationCommand, serializeAws_restXmlPutObjectLockConfigurationCommand, } from "../protocols/Aws_restXml";
var PutObjectLockConfigurationCommand = (function (_super) {
    __extends(PutObjectLockConfigurationCommand, _super);
    function PutObjectLockConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutObjectLockConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutObjectLockConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutObjectLockConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PutObjectLockConfigurationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutObjectLockConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutObjectLockConfigurationCommand(input, context);
    };
    PutObjectLockConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutObjectLockConfigurationCommand(output, context);
    };
    return PutObjectLockConfigurationCommand;
}($Command));
export { PutObjectLockConfigurationCommand };
