import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutObjectLegalHoldOutput, PutObjectLegalHoldRequest } from "../models/models_0";
import { deserializeAws_restXmlPutObjectLegalHoldCommand, serializeAws_restXmlPutObjectLegalHoldCommand, } from "../protocols/Aws_restXml";
var PutObjectLegalHoldCommand = (function (_super) {
    __extends(PutObjectLegalHoldCommand, _super);
    function PutObjectLegalHoldCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutObjectLegalHoldCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutObjectLegalHoldCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutObjectLegalHoldRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PutObjectLegalHoldOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutObjectLegalHoldCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutObjectLegalHoldCommand(input, context);
    };
    PutObjectLegalHoldCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutObjectLegalHoldCommand(output, context);
    };
    return PutObjectLegalHoldCommand;
}($Command));
export { PutObjectLegalHoldCommand };
