import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutObjectAclOutput, PutObjectAclRequest } from "../models/models_0";
import { deserializeAws_restXmlPutObjectAclCommand, serializeAws_restXmlPutObjectAclCommand, } from "../protocols/Aws_restXml";
var PutObjectAclCommand = (function (_super) {
    __extends(PutObjectAclCommand, _super);
    function PutObjectAclCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutObjectAclCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutObjectAclCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutObjectAclRequest.filterSensitiveLog,
            outputFilterSensitiveLog: PutObjectAclOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutObjectAclCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutObjectAclCommand(input, context);
    };
    PutObjectAclCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutObjectAclCommand(output, context);
    };
    return PutObjectAclCommand;
}($Command));
export { PutObjectAclCommand };
