import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketWebsiteRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketWebsiteCommand, serializeAws_restXmlPutBucketWebsiteCommand, } from "../protocols/Aws_restXml";
var PutBucketWebsiteCommand = (function (_super) {
    __extends(PutBucketWebsiteCommand, _super);
    function PutBucketWebsiteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketWebsiteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketWebsiteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketWebsiteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketWebsiteCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketWebsiteCommand(input, context);
    };
    PutBucketWebsiteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketWebsiteCommand(output, context);
    };
    return PutBucketWebsiteCommand;
}($Command));
export { PutBucketWebsiteCommand };
