import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketPolicyRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketPolicyCommand, serializeAws_restXmlPutBucketPolicyCommand, } from "../protocols/Aws_restXml";
var PutBucketPolicyCommand = (function (_super) {
    __extends(PutBucketPolicyCommand, _super);
    function PutBucketPolicyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketPolicyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketPolicyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketPolicyRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketPolicyCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketPolicyCommand(input, context);
    };
    PutBucketPolicyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketPolicyCommand(output, context);
    };
    return PutBucketPolicyCommand;
}($Command));
export { PutBucketPolicyCommand };
