import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketOwnershipControlsRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketOwnershipControlsCommand, serializeAws_restXmlPutBucketOwnershipControlsCommand, } from "../protocols/Aws_restXml";
var PutBucketOwnershipControlsCommand = (function (_super) {
    __extends(PutBucketOwnershipControlsCommand, _super);
    function PutBucketOwnershipControlsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketOwnershipControlsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, { input: this.input, requestChecksumRequired: true }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketOwnershipControlsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketOwnershipControlsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketOwnershipControlsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketOwnershipControlsCommand(input, context);
    };
    PutBucketOwnershipControlsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketOwnershipControlsCommand(output, context);
    };
    return PutBucketOwnershipControlsCommand;
}($Command));
export { PutBucketOwnershipControlsCommand };
