import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketMetricsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketMetricsConfigurationCommand, serializeAws_restXmlPutBucketMetricsConfigurationCommand, } from "../protocols/Aws_restXml";
var PutBucketMetricsConfigurationCommand = (function (_super) {
    __extends(PutBucketMetricsConfigurationCommand, _super);
    function PutBucketMetricsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketMetricsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketMetricsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketMetricsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketMetricsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketMetricsConfigurationCommand(input, context);
    };
    PutBucketMetricsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketMetricsConfigurationCommand(output, context);
    };
    return PutBucketMetricsConfigurationCommand;
}($Command));
export { PutBucketMetricsConfigurationCommand };
