import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketLifecycleConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketLifecycleConfigurationCommand, serializeAws_restXmlPutBucketLifecycleConfigurationCommand, } from "../protocols/Aws_restXml";
var PutBucketLifecycleConfigurationCommand = (function (_super) {
    __extends(PutBucketLifecycleConfigurationCommand, _super);
    function PutBucketLifecycleConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketLifecycleConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: true,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketLifecycleConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketLifecycleConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketLifecycleConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketLifecycleConfigurationCommand(input, context);
    };
    PutBucketLifecycleConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketLifecycleConfigurationCommand(output, context);
    };
    return PutBucketLifecycleConfigurationCommand;
}($Command));
export { PutBucketLifecycleConfigurationCommand };
