import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketIntelligentTieringConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketIntelligentTieringConfigurationCommand, serializeAws_restXmlPutBucketIntelligentTieringConfigurationCommand, } from "../protocols/Aws_restXml";
var PutBucketIntelligentTieringConfigurationCommand = (function (_super) {
    __extends(PutBucketIntelligentTieringConfigurationCommand, _super);
    function PutBucketIntelligentTieringConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketIntelligentTieringConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketIntelligentTieringConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketIntelligentTieringConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketIntelligentTieringConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketIntelligentTieringConfigurationCommand(input, context);
    };
    PutBucketIntelligentTieringConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketIntelligentTieringConfigurationCommand(output, context);
    };
    return PutBucketIntelligentTieringConfigurationCommand;
}($Command));
export { PutBucketIntelligentTieringConfigurationCommand };
