import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketAnalyticsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketAnalyticsConfigurationCommand, serializeAws_restXmlPutBucketAnalyticsConfigurationCommand, } from "../protocols/Aws_restXml";
var PutBucketAnalyticsConfigurationCommand = (function (_super) {
    __extends(PutBucketAnalyticsConfigurationCommand, _super);
    function PutBucketAnalyticsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketAnalyticsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketAnalyticsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketAnalyticsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketAnalyticsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketAnalyticsConfigurationCommand(input, context);
    };
    PutBucketAnalyticsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketAnalyticsConfigurationCommand(output, context);
    };
    return PutBucketAnalyticsConfigurationCommand;
}($Command));
export { PutBucketAnalyticsConfigurationCommand };
