import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getFlexibleChecksumsPlugin } from "@aws-sdk/middleware-flexible-checksums";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { PutBucketAccelerateConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlPutBucketAccelerateConfigurationCommand, serializeAws_restXmlPutBucketAccelerateConfigurationCommand, } from "../protocols/Aws_restXml";
var PutBucketAccelerateConfigurationCommand = (function (_super) {
    __extends(PutBucketAccelerateConfigurationCommand, _super);
    function PutBucketAccelerateConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    PutBucketAccelerateConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        this.middlewareStack.use(getFlexibleChecksumsPlugin(configuration, {
            input: this.input,
            requestAlgorithmMember: "ChecksumAlgorithm",
            requestChecksumRequired: false,
        }));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "PutBucketAccelerateConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: PutBucketAccelerateConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: function (output) { return output; },
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    PutBucketAccelerateConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlPutBucketAccelerateConfigurationCommand(input, context);
    };
    PutBucketAccelerateConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlPutBucketAccelerateConfigurationCommand(output, context);
    };
    return PutBucketAccelerateConfigurationCommand;
}($Command));
export { PutBucketAccelerateConfigurationCommand };
