import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListObjectsV2Output, ListObjectsV2Request } from "../models/models_0";
import { deserializeAws_restXmlListObjectsV2Command, serializeAws_restXmlListObjectsV2Command, } from "../protocols/Aws_restXml";
var ListObjectsV2Command = (function (_super) {
    __extends(ListObjectsV2Command, _super);
    function ListObjectsV2Command(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListObjectsV2Command.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListObjectsV2Command";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListObjectsV2Request.filterSensitiveLog,
            outputFilterSensitiveLog: ListObjectsV2Output.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListObjectsV2Command.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListObjectsV2Command(input, context);
    };
    ListObjectsV2Command.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListObjectsV2Command(output, context);
    };
    return ListObjectsV2Command;
}($Command));
export { ListObjectsV2Command };
