import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListObjectsOutput, ListObjectsRequest } from "../models/models_0";
import { deserializeAws_restXmlListObjectsCommand, serializeAws_restXmlListObjectsCommand, } from "../protocols/Aws_restXml";
var ListObjectsCommand = (function (_super) {
    __extends(ListObjectsCommand, _super);
    function ListObjectsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListObjectsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListObjectsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListObjectsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListObjectsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListObjectsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListObjectsCommand(input, context);
    };
    ListObjectsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListObjectsCommand(output, context);
    };
    return ListObjectsCommand;
}($Command));
export { ListObjectsCommand };
