import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListObjectVersionsOutput, ListObjectVersionsRequest } from "../models/models_0";
import { deserializeAws_restXmlListObjectVersionsCommand, serializeAws_restXmlListObjectVersionsCommand, } from "../protocols/Aws_restXml";
var ListObjectVersionsCommand = (function (_super) {
    __extends(ListObjectVersionsCommand, _super);
    function ListObjectVersionsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListObjectVersionsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListObjectVersionsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListObjectVersionsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListObjectVersionsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListObjectVersionsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListObjectVersionsCommand(input, context);
    };
    ListObjectVersionsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListObjectVersionsCommand(output, context);
    };
    return ListObjectVersionsCommand;
}($Command));
export { ListObjectVersionsCommand };
