import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListMultipartUploadsOutput, ListMultipartUploadsRequest } from "../models/models_0";
import { deserializeAws_restXmlListMultipartUploadsCommand, serializeAws_restXmlListMultipartUploadsCommand, } from "../protocols/Aws_restXml";
var ListMultipartUploadsCommand = (function (_super) {
    __extends(ListMultipartUploadsCommand, _super);
    function ListMultipartUploadsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListMultipartUploadsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListMultipartUploadsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListMultipartUploadsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListMultipartUploadsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListMultipartUploadsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListMultipartUploadsCommand(input, context);
    };
    ListMultipartUploadsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListMultipartUploadsCommand(output, context);
    };
    return ListMultipartUploadsCommand;
}($Command));
export { ListMultipartUploadsCommand };
