import { __extends } from "tslib";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListBucketsOutput } from "../models/models_0";
import { deserializeAws_restXmlListBucketsCommand, serializeAws_restXmlListBucketsCommand, } from "../protocols/Aws_restXml";
var ListBucketsCommand = (function (_super) {
    __extends(ListBucketsCommand, _super);
    function ListBucketsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListBucketsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListBucketsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: function (input) { return input; },
            outputFilterSensitiveLog: ListBucketsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListBucketsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListBucketsCommand(input, context);
    };
    ListBucketsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListBucketsCommand(output, context);
    };
    return ListBucketsCommand;
}($Command));
export { ListBucketsCommand };
