import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListBucketMetricsConfigurationsOutput, ListBucketMetricsConfigurationsRequest } from "../models/models_0";
import { deserializeAws_restXmlListBucketMetricsConfigurationsCommand, serializeAws_restXmlListBucketMetricsConfigurationsCommand, } from "../protocols/Aws_restXml";
var ListBucketMetricsConfigurationsCommand = (function (_super) {
    __extends(ListBucketMetricsConfigurationsCommand, _super);
    function ListBucketMetricsConfigurationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListBucketMetricsConfigurationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListBucketMetricsConfigurationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListBucketMetricsConfigurationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListBucketMetricsConfigurationsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListBucketMetricsConfigurationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListBucketMetricsConfigurationsCommand(input, context);
    };
    ListBucketMetricsConfigurationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListBucketMetricsConfigurationsCommand(output, context);
    };
    return ListBucketMetricsConfigurationsCommand;
}($Command));
export { ListBucketMetricsConfigurationsCommand };
