import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListBucketIntelligentTieringConfigurationsOutput, ListBucketIntelligentTieringConfigurationsRequest, } from "../models/models_0";
import { deserializeAws_restXmlListBucketIntelligentTieringConfigurationsCommand, serializeAws_restXmlListBucketIntelligentTieringConfigurationsCommand, } from "../protocols/Aws_restXml";
var ListBucketIntelligentTieringConfigurationsCommand = (function (_super) {
    __extends(ListBucketIntelligentTieringConfigurationsCommand, _super);
    function ListBucketIntelligentTieringConfigurationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListBucketIntelligentTieringConfigurationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListBucketIntelligentTieringConfigurationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListBucketIntelligentTieringConfigurationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListBucketIntelligentTieringConfigurationsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListBucketIntelligentTieringConfigurationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListBucketIntelligentTieringConfigurationsCommand(input, context);
    };
    ListBucketIntelligentTieringConfigurationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListBucketIntelligentTieringConfigurationsCommand(output, context);
    };
    return ListBucketIntelligentTieringConfigurationsCommand;
}($Command));
export { ListBucketIntelligentTieringConfigurationsCommand };
