import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { ListBucketAnalyticsConfigurationsOutput, ListBucketAnalyticsConfigurationsRequest } from "../models/models_0";
import { deserializeAws_restXmlListBucketAnalyticsConfigurationsCommand, serializeAws_restXmlListBucketAnalyticsConfigurationsCommand, } from "../protocols/Aws_restXml";
var ListBucketAnalyticsConfigurationsCommand = (function (_super) {
    __extends(ListBucketAnalyticsConfigurationsCommand, _super);
    function ListBucketAnalyticsConfigurationsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    ListBucketAnalyticsConfigurationsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "ListBucketAnalyticsConfigurationsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: ListBucketAnalyticsConfigurationsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: ListBucketAnalyticsConfigurationsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    ListBucketAnalyticsConfigurationsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlListBucketAnalyticsConfigurationsCommand(input, context);
    };
    ListBucketAnalyticsConfigurationsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlListBucketAnalyticsConfigurationsCommand(output, context);
    };
    return ListBucketAnalyticsConfigurationsCommand;
}($Command));
export { ListBucketAnalyticsConfigurationsCommand };
