import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetPublicAccessBlockOutput, GetPublicAccessBlockRequest } from "../models/models_0";
import { deserializeAws_restXmlGetPublicAccessBlockCommand, serializeAws_restXmlGetPublicAccessBlockCommand, } from "../protocols/Aws_restXml";
var GetPublicAccessBlockCommand = (function (_super) {
    __extends(GetPublicAccessBlockCommand, _super);
    function GetPublicAccessBlockCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetPublicAccessBlockCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetPublicAccessBlockCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetPublicAccessBlockRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetPublicAccessBlockOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetPublicAccessBlockCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetPublicAccessBlockCommand(input, context);
    };
    GetPublicAccessBlockCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetPublicAccessBlockCommand(output, context);
    };
    return GetPublicAccessBlockCommand;
}($Command));
export { GetPublicAccessBlockCommand };
