import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetObjectTaggingOutput, GetObjectTaggingRequest } from "../models/models_0";
import { deserializeAws_restXmlGetObjectTaggingCommand, serializeAws_restXmlGetObjectTaggingCommand, } from "../protocols/Aws_restXml";
var GetObjectTaggingCommand = (function (_super) {
    __extends(GetObjectTaggingCommand, _super);
    function GetObjectTaggingCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetObjectTaggingCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetObjectTaggingCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetObjectTaggingRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetObjectTaggingOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetObjectTaggingCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetObjectTaggingCommand(input, context);
    };
    GetObjectTaggingCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetObjectTaggingCommand(output, context);
    };
    return GetObjectTaggingCommand;
}($Command));
export { GetObjectTaggingCommand };
