import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetObjectLockConfigurationOutput, GetObjectLockConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetObjectLockConfigurationCommand, serializeAws_restXmlGetObjectLockConfigurationCommand, } from "../protocols/Aws_restXml";
var GetObjectLockConfigurationCommand = (function (_super) {
    __extends(GetObjectLockConfigurationCommand, _super);
    function GetObjectLockConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetObjectLockConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetObjectLockConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetObjectLockConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetObjectLockConfigurationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetObjectLockConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetObjectLockConfigurationCommand(input, context);
    };
    GetObjectLockConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetObjectLockConfigurationCommand(output, context);
    };
    return GetObjectLockConfigurationCommand;
}($Command));
export { GetObjectLockConfigurationCommand };
