import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { getSsecPlugin } from "@aws-sdk/middleware-ssec";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetObjectAttributesOutput, GetObjectAttributesRequest } from "../models/models_0";
import { deserializeAws_restXmlGetObjectAttributesCommand, serializeAws_restXmlGetObjectAttributesCommand, } from "../protocols/Aws_restXml";
var GetObjectAttributesCommand = (function (_super) {
    __extends(GetObjectAttributesCommand, _super);
    function GetObjectAttributesCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetObjectAttributesCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getSsecPlugin(configuration));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetObjectAttributesCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetObjectAttributesRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetObjectAttributesOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetObjectAttributesCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetObjectAttributesCommand(input, context);
    };
    GetObjectAttributesCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetObjectAttributesCommand(output, context);
    };
    return GetObjectAttributesCommand;
}($Command));
export { GetObjectAttributesCommand };
