import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetObjectAclOutput, GetObjectAclRequest } from "../models/models_0";
import { deserializeAws_restXmlGetObjectAclCommand, serializeAws_restXmlGetObjectAclCommand, } from "../protocols/Aws_restXml";
var GetObjectAclCommand = (function (_super) {
    __extends(GetObjectAclCommand, _super);
    function GetObjectAclCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetObjectAclCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetObjectAclCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetObjectAclRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetObjectAclOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetObjectAclCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetObjectAclCommand(input, context);
    };
    GetObjectAclCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetObjectAclCommand(output, context);
    };
    return GetObjectAclCommand;
}($Command));
export { GetObjectAclCommand };
