import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketWebsiteOutput, GetBucketWebsiteRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketWebsiteCommand, serializeAws_restXmlGetBucketWebsiteCommand, } from "../protocols/Aws_restXml";
var GetBucketWebsiteCommand = (function (_super) {
    __extends(GetBucketWebsiteCommand, _super);
    function GetBucketWebsiteCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketWebsiteCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketWebsiteCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketWebsiteRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketWebsiteOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketWebsiteCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketWebsiteCommand(input, context);
    };
    GetBucketWebsiteCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketWebsiteCommand(output, context);
    };
    return GetBucketWebsiteCommand;
}($Command));
export { GetBucketWebsiteCommand };
