import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketVersioningOutput, GetBucketVersioningRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketVersioningCommand, serializeAws_restXmlGetBucketVersioningCommand, } from "../protocols/Aws_restXml";
var GetBucketVersioningCommand = (function (_super) {
    __extends(GetBucketVersioningCommand, _super);
    function GetBucketVersioningCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketVersioningCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketVersioningCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketVersioningRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketVersioningOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketVersioningCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketVersioningCommand(input, context);
    };
    GetBucketVersioningCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketVersioningCommand(output, context);
    };
    return GetBucketVersioningCommand;
}($Command));
export { GetBucketVersioningCommand };
