import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketReplicationOutput, GetBucketReplicationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketReplicationCommand, serializeAws_restXmlGetBucketReplicationCommand, } from "../protocols/Aws_restXml";
var GetBucketReplicationCommand = (function (_super) {
    __extends(GetBucketReplicationCommand, _super);
    function GetBucketReplicationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketReplicationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketReplicationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketReplicationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketReplicationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketReplicationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketReplicationCommand(input, context);
    };
    GetBucketReplicationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketReplicationCommand(output, context);
    };
    return GetBucketReplicationCommand;
}($Command));
export { GetBucketReplicationCommand };
