import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketPolicyStatusOutput, GetBucketPolicyStatusRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketPolicyStatusCommand, serializeAws_restXmlGetBucketPolicyStatusCommand, } from "../protocols/Aws_restXml";
var GetBucketPolicyStatusCommand = (function (_super) {
    __extends(GetBucketPolicyStatusCommand, _super);
    function GetBucketPolicyStatusCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketPolicyStatusCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketPolicyStatusCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketPolicyStatusRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketPolicyStatusOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketPolicyStatusCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketPolicyStatusCommand(input, context);
    };
    GetBucketPolicyStatusCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketPolicyStatusCommand(output, context);
    };
    return GetBucketPolicyStatusCommand;
}($Command));
export { GetBucketPolicyStatusCommand };
