import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketPolicyOutput, GetBucketPolicyRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketPolicyCommand, serializeAws_restXmlGetBucketPolicyCommand, } from "../protocols/Aws_restXml";
var GetBucketPolicyCommand = (function (_super) {
    __extends(GetBucketPolicyCommand, _super);
    function GetBucketPolicyCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketPolicyCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketPolicyCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketPolicyRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketPolicyOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketPolicyCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketPolicyCommand(input, context);
    };
    GetBucketPolicyCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketPolicyCommand(output, context);
    };
    return GetBucketPolicyCommand;
}($Command));
export { GetBucketPolicyCommand };
