import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketOwnershipControlsOutput, GetBucketOwnershipControlsRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketOwnershipControlsCommand, serializeAws_restXmlGetBucketOwnershipControlsCommand, } from "../protocols/Aws_restXml";
var GetBucketOwnershipControlsCommand = (function (_super) {
    __extends(GetBucketOwnershipControlsCommand, _super);
    function GetBucketOwnershipControlsCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketOwnershipControlsCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketOwnershipControlsCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketOwnershipControlsRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketOwnershipControlsOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketOwnershipControlsCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketOwnershipControlsCommand(input, context);
    };
    GetBucketOwnershipControlsCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketOwnershipControlsCommand(output, context);
    };
    return GetBucketOwnershipControlsCommand;
}($Command));
export { GetBucketOwnershipControlsCommand };
