import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketNotificationConfigurationRequest, NotificationConfiguration } from "../models/models_0";
import { deserializeAws_restXmlGetBucketNotificationConfigurationCommand, serializeAws_restXmlGetBucketNotificationConfigurationCommand, } from "../protocols/Aws_restXml";
var GetBucketNotificationConfigurationCommand = (function (_super) {
    __extends(GetBucketNotificationConfigurationCommand, _super);
    function GetBucketNotificationConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketNotificationConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketNotificationConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketNotificationConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: NotificationConfiguration.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketNotificationConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketNotificationConfigurationCommand(input, context);
    };
    GetBucketNotificationConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketNotificationConfigurationCommand(output, context);
    };
    return GetBucketNotificationConfigurationCommand;
}($Command));
export { GetBucketNotificationConfigurationCommand };
