import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketMetricsConfigurationOutput, GetBucketMetricsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketMetricsConfigurationCommand, serializeAws_restXmlGetBucketMetricsConfigurationCommand, } from "../protocols/Aws_restXml";
var GetBucketMetricsConfigurationCommand = (function (_super) {
    __extends(GetBucketMetricsConfigurationCommand, _super);
    function GetBucketMetricsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketMetricsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketMetricsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketMetricsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketMetricsConfigurationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketMetricsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketMetricsConfigurationCommand(input, context);
    };
    GetBucketMetricsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketMetricsConfigurationCommand(output, context);
    };
    return GetBucketMetricsConfigurationCommand;
}($Command));
export { GetBucketMetricsConfigurationCommand };
