import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketLoggingOutput, GetBucketLoggingRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketLoggingCommand, serializeAws_restXmlGetBucketLoggingCommand, } from "../protocols/Aws_restXml";
var GetBucketLoggingCommand = (function (_super) {
    __extends(GetBucketLoggingCommand, _super);
    function GetBucketLoggingCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketLoggingCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketLoggingCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketLoggingRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketLoggingOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketLoggingCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketLoggingCommand(input, context);
    };
    GetBucketLoggingCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketLoggingCommand(output, context);
    };
    return GetBucketLoggingCommand;
}($Command));
export { GetBucketLoggingCommand };
