import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketLocationOutput, GetBucketLocationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketLocationCommand, serializeAws_restXmlGetBucketLocationCommand, } from "../protocols/Aws_restXml";
var GetBucketLocationCommand = (function (_super) {
    __extends(GetBucketLocationCommand, _super);
    function GetBucketLocationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketLocationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketLocationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketLocationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketLocationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketLocationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketLocationCommand(input, context);
    };
    GetBucketLocationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketLocationCommand(output, context);
    };
    return GetBucketLocationCommand;
}($Command));
export { GetBucketLocationCommand };
