import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketLifecycleConfigurationOutput, GetBucketLifecycleConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketLifecycleConfigurationCommand, serializeAws_restXmlGetBucketLifecycleConfigurationCommand, } from "../protocols/Aws_restXml";
var GetBucketLifecycleConfigurationCommand = (function (_super) {
    __extends(GetBucketLifecycleConfigurationCommand, _super);
    function GetBucketLifecycleConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketLifecycleConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketLifecycleConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketLifecycleConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketLifecycleConfigurationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketLifecycleConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketLifecycleConfigurationCommand(input, context);
    };
    GetBucketLifecycleConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketLifecycleConfigurationCommand(output, context);
    };
    return GetBucketLifecycleConfigurationCommand;
}($Command));
export { GetBucketLifecycleConfigurationCommand };
