import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketEncryptionOutput, GetBucketEncryptionRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketEncryptionCommand, serializeAws_restXmlGetBucketEncryptionCommand, } from "../protocols/Aws_restXml";
var GetBucketEncryptionCommand = (function (_super) {
    __extends(GetBucketEncryptionCommand, _super);
    function GetBucketEncryptionCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketEncryptionCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketEncryptionCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketEncryptionRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketEncryptionOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketEncryptionCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketEncryptionCommand(input, context);
    };
    GetBucketEncryptionCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketEncryptionCommand(output, context);
    };
    return GetBucketEncryptionCommand;
}($Command));
export { GetBucketEncryptionCommand };
