import { __extends } from "tslib";
import { getBucketEndpointPlugin } from "@aws-sdk/middleware-bucket-endpoint";
import { getSerdePlugin } from "@aws-sdk/middleware-serde";
import { Command as $Command } from "@aws-sdk/smithy-client";
import { GetBucketAnalyticsConfigurationOutput, GetBucketAnalyticsConfigurationRequest } from "../models/models_0";
import { deserializeAws_restXmlGetBucketAnalyticsConfigurationCommand, serializeAws_restXmlGetBucketAnalyticsConfigurationCommand, } from "../protocols/Aws_restXml";
var GetBucketAnalyticsConfigurationCommand = (function (_super) {
    __extends(GetBucketAnalyticsConfigurationCommand, _super);
    function GetBucketAnalyticsConfigurationCommand(input) {
        var _this = _super.call(this) || this;
        _this.input = input;
        return _this;
    }
    GetBucketAnalyticsConfigurationCommand.prototype.resolveMiddleware = function (clientStack, configuration, options) {
        this.middlewareStack.use(getSerdePlugin(configuration, this.serialize, this.deserialize));
        this.middlewareStack.use(getBucketEndpointPlugin(configuration));
        var stack = clientStack.concat(this.middlewareStack);
        var logger = configuration.logger;
        var clientName = "S3Client";
        var commandName = "GetBucketAnalyticsConfigurationCommand";
        var handlerExecutionContext = {
            logger: logger,
            clientName: clientName,
            commandName: commandName,
            inputFilterSensitiveLog: GetBucketAnalyticsConfigurationRequest.filterSensitiveLog,
            outputFilterSensitiveLog: GetBucketAnalyticsConfigurationOutput.filterSensitiveLog,
        };
        var requestHandler = configuration.requestHandler;
        return stack.resolve(function (request) {
            return requestHandler.handle(request.request, options || {});
        }, handlerExecutionContext);
    };
    GetBucketAnalyticsConfigurationCommand.prototype.serialize = function (input, context) {
        return serializeAws_restXmlGetBucketAnalyticsConfigurationCommand(input, context);
    };
    GetBucketAnalyticsConfigurationCommand.prototype.deserialize = function (output, context) {
        return deserializeAws_restXmlGetBucketAnalyticsConfigurationCommand(output, context);
    };
    return GetBucketAnalyticsConfigurationCommand;
}($Command));
export { GetBucketAnalyticsConfigurationCommand };
